/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.statistics;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldInstance;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.statistics.InvalidStatisticsFieldInstance;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrackingStatisticServiceImpl
implements TrackingStatisticService {
    public static final String NONE_NAME_KEY = "gh.rapid.config.statistics.none";
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private TrackingStatisticManager trackingStatisticManager;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private TimeTrackingConfiguration timeTrackingConfiguration;
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private ProjectManager projectManager;

    @Override
    public List<StatisticsField> getAvailableTrackingStatistics() {
        List<StatisticsFieldConfig> configs = this.getAvailableConfigs();
        ArrayList<StatisticsField> instances = new ArrayList<StatisticsField>();
        for (StatisticsFieldConfig config : configs) {
            instances.add(this.getInstanceOf(config).getValue());
        }
        return instances;
    }

    @Override
    public ServiceOutcome<Void> updateTrackingStatistic(ApplicationUser user, RapidView rapidView, StatisticsFieldConfig trackingStatistic) {
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        this.trackingStatisticManager.updateTrackingStatistic(rapidView, trackingStatistic);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<StatisticsField> getTrackingStatisticStrict(RapidView rapidView) {
        StatisticsFieldConfig config = this.trackingStatisticManager.getTrackingStatistic(rapidView);
        return this.getInstanceOf(config);
    }

    @Override
    public StatisticsField getTrackingStatistic(RapidView rapidView) {
        StatisticsFieldConfig config = this.trackingStatisticManager.getTrackingStatistic(rapidView);
        ServiceOutcome<StatisticsField> outcome = this.getInstanceOf(config);
        if (outcome.isValid()) {
            return outcome.getValue();
        }
        return this.getInvalidTrackingStatistic(rapidView);
    }

    @Override
    public StatisticsField getInvalidTrackingStatistic(RapidView rapidView) {
        StatisticsFieldConfig config = this.trackingStatisticManager.getTrackingStatistic(rapidView);
        return new InvalidStatisticsFieldInstance(config);
    }

    @Override
    @Nonnull
    public ServiceOutcome<StatisticsField> getInstanceOf(@Nonnull StatisticsFieldConfig config) {
        if (config.getType() == StatisticsFieldConfig.Type.JIRA_FIELD) {
            ServiceOutcome<Field> result = this.getJiraField(config.getFieldId());
            if (result.isValid()) {
                if (config.getFieldId().equals("timeestimate")) {
                    return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forJiraFieldWithNameWithDocumentId(config, result.getValue(), "gh.rapid.config.tracking.statistic.timetracking.remaining", "timeestimate"));
                }
                return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forJiraField(config, result.getValue()));
            }
            return ServiceOutcomeImpl.error(result);
        }
        String nameKey = this.getNameKey(config.getType());
        return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forNonField(config, nameKey));
    }

    @Override
    public boolean isTrackingStatisticFieldAndApplicable(StatisticsField trackingStatistic, Issue issue) {
        return this.isTrackingStatisticFieldAndApplicable(trackingStatistic, issue.getProjectObject().getId(), issue.getIssueType().getId());
    }

    private boolean isTrackingStatisticFieldAndApplicable(StatisticsField trackingStatistic, Long projectId, String issueTypeId) {
        return trackingStatistic.isFieldBased() && this.isFieldApplicable(trackingStatistic, projectId, issueTypeId);
    }

    @Override
    public boolean isTrackingStatisticFieldAndNotApplicable(StatisticsField trackingStatistic, Issue issue) {
        return this.isTrackingStatisticFieldAndNotApplicable(trackingStatistic, issue.getProjectObject().getId(), issue.getIssueType().getId());
    }

    @Override
    public boolean isTrackingStatisticFieldAndNotApplicable(StatisticsField trackingStatistic, Long projectId, String issueTypeId) {
        return trackingStatistic.isFieldBased() && !this.isFieldApplicable(trackingStatistic, projectId, issueTypeId);
    }

    @Override
    public boolean isTrackingStatisticValidAndEnabled(StatisticsField trackingStatistic) {
        return trackingStatistic.isValid() && trackingStatistic.isEnabled();
    }

    @Override
    public boolean isRemainingEstimateStatisticsField(StatisticsField statisticsField) {
        return statisticsField.isFieldBased() && statisticsField.getField().getId().equals("timeestimate");
    }

    private List<StatisticsFieldConfig> getAvailableConfigs() {
        ArrayList<StatisticsFieldConfig> statisticsFields = new ArrayList<StatisticsFieldConfig>();
        statisticsFields.add(StatisticsFieldConfig.buildNone());
        List<String> fieldIds = this.getValidFieldIds();
        for (String fieldId : fieldIds) {
            StatisticsFieldConfig forField = StatisticsFieldConfig.builder().type(StatisticsFieldConfig.Type.JIRA_FIELD).fieldId(fieldId).build();
            statisticsFields.add(forField);
        }
        return statisticsFields;
    }

    private boolean isFieldApplicable(StatisticsField trackingStatistic, Long projectId, String issueTypeId) {
        Field field = trackingStatistic.getField();
        if (field instanceof TimeEstimateSystemField) {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.projectManager.getProjectObj(projectId), issueTypeId);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("timetracking");
            return !fieldLayoutItem.isHidden();
        }
        if (field instanceof CustomField) {
            return this.customFieldService.isFieldApplicable((CustomField)field, projectId, issueTypeId);
        }
        throw new IllegalStateException("Tracking statistic should be either TimeEstimateSystemField or CustomField");
    }

    private String getNameKey(StatisticsFieldConfig.Type type) {
        if (type == StatisticsFieldConfig.Type.NONE) {
            return NONE_NAME_KEY;
        }
        return "";
    }

    private List<String> getValidFieldIds() {
        ArrayList<String> validFields = new ArrayList<String>();
        if (this.timeTrackingConfiguration.enabled()) {
            validFields.add("timeestimate");
        }
        return validFields;
    }

    @Nonnull
    private ServiceOutcome<Field> getJiraField(String fieldId) {
        Field field = this.fieldManager.getField(fieldId);
        if (field == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.config.statistics.error.field.not.found", fieldId);
        }
        List<String> validFieldIds = this.getValidFieldIds();
        for (String validFieldId : validFieldIds) {
            if (!validFieldId.equals(field.getId())) continue;
            return ServiceOutcomeImpl.ok(field);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.statistics.error.field.not.found", fieldId);
    }
}

