/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.statistics;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldInstance;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.InvalidStatisticsFieldInstance;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimateStatisticServiceImpl
implements EstimateStatisticService {
    public static final String ISSUE_COUNT_NAME_KEY = "gh.rapid.config.statistics.issuecount";
    public static final String NONE_NAME_KEY = "gh.rapid.config.statistics.none";
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private EstimateStatisticManager estimateStatisticManager;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private TimeTrackingConfiguration timeTrackingConfiguration;
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private ProjectManager projectManager;

    @Override
    public List<StatisticsField> getAvailableEstimateStatistics() {
        List<StatisticsFieldConfig> configs = this.getAvailableConfigs();
        ArrayList<StatisticsField> instances = new ArrayList<StatisticsField>();
        for (StatisticsFieldConfig config : configs) {
            instances.add(this.getInstanceOf(config).getValue());
        }
        return instances;
    }

    @Override
    public ServiceOutcome<Void> updateEstimateStatistic(ApplicationUser user, RapidView rapidView, StatisticsFieldConfig estimateStatistic) {
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        this.estimateStatisticManager.updateEstimateStatistic(rapidView, estimateStatistic);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<StatisticsField> getEstimateStatisticStrict(RapidView rapidView) {
        StatisticsFieldConfig config = this.estimateStatisticManager.getEstimateStatistic(rapidView);
        return this.getInstanceOf(config);
    }

    @Override
    public StatisticsField getEstimateStatistic(RapidView rapidView) {
        StatisticsFieldConfig config = this.estimateStatisticManager.getEstimateStatistic(rapidView);
        ServiceOutcome<StatisticsField> outcome = this.getInstanceOf(config);
        if (outcome.isValid()) {
            return outcome.getValue();
        }
        return this.getInvalidEstimateStatistic(rapidView);
    }

    @Override
    public StatisticsField getInvalidEstimateStatistic(RapidView rapidView) {
        StatisticsFieldConfig config = this.estimateStatisticManager.getEstimateStatistic(rapidView);
        return new InvalidStatisticsFieldInstance(config);
    }

    @Override
    @Nonnull
    public ServiceOutcome<StatisticsField> getInstanceOf(@Nonnull StatisticsFieldConfig config) {
        if (config.getType() == StatisticsFieldConfig.Type.JIRA_FIELD) {
            ServiceOutcome<Field> result = this.getJiraField(config.getFieldId());
            if (result.isValid()) {
                if (config.getFieldId().equals("timeoriginalestimate")) {
                    return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forJiraFieldWithNameWithDocumentId(config, result.getValue(), "gh.rapid.config.estimation.statistic.timetracking.original", "timeoriginalestimate"));
                }
                return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forJiraField(config, result.getValue()));
            }
            return ServiceOutcomeImpl.error(result);
        }
        String nameKey = this.getNameKey(config.getType());
        return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forNonField(config, nameKey));
    }

    @Override
    public boolean isEstimateStatisticFieldAndNotApplicable(StatisticsField estimateStatistic, Issue issue) {
        return this.isEstimateStatisticFieldAndNotApplicable(estimateStatistic, issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
    }

    @Override
    public boolean isEstimateStatisticFieldAndNotApplicable(StatisticsField estimateStatistic, Long projectId, String issueTypeId) {
        return estimateStatistic.isFieldBased() && !this.isFieldApplicable(estimateStatistic, projectId, issueTypeId);
    }

    @Override
    public boolean isEstimateStatisticValidAndEnabled(StatisticsField estimateStatistic) {
        return estimateStatistic.isValid() && estimateStatistic.isEnabled();
    }

    private List<StatisticsFieldConfig> getAvailableConfigs() {
        ArrayList<StatisticsFieldConfig> statisticsFields = new ArrayList<StatisticsFieldConfig>();
        statisticsFields.add(StatisticsFieldConfig.buildIssueCount());
        List<String> fieldIds = this.getValidFieldIds();
        for (String fieldId : fieldIds) {
            StatisticsFieldConfig forField = StatisticsFieldConfig.builder().type(StatisticsFieldConfig.Type.JIRA_FIELD).fieldId(fieldId).build();
            statisticsFields.add(forField);
        }
        return statisticsFields;
    }

    private boolean isFieldApplicable(StatisticsField estimateStatistic, Long projectId, String issueTypeId) {
        Field field = estimateStatistic.getField();
        if (field instanceof OriginalEstimateSystemField) {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.projectManager.getProjectObj(projectId), issueTypeId);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("timetracking");
            return !fieldLayoutItem.isHidden();
        }
        if (field instanceof CustomField) {
            return this.customFieldService.isFieldApplicable((CustomField)field, projectId, issueTypeId);
        }
        throw new IllegalStateException("Estimate statistic should be either OriginalEstimateSystemField or CustomField");
    }

    private String getNameKey(StatisticsFieldConfig.Type type) {
        if (type == StatisticsFieldConfig.Type.ISSUE_COUNT) {
            return ISSUE_COUNT_NAME_KEY;
        }
        if (type == StatisticsFieldConfig.Type.NONE) {
            return NONE_NAME_KEY;
        }
        return "";
    }

    private List<String> getValidFieldIds() {
        ArrayList<String> validFields = new ArrayList<String>();
        if (this.timeTrackingConfiguration.enabled()) {
            validFields.add("timeoriginalestimate");
        }
        List<CustomField> numberCustomFields = this.customFieldService.getCustomFields(NumberCFType.class, false);
        for (CustomField numberCustomField : numberCustomFields) {
            validFields.add(numberCustomField.getId());
        }
        return validFields;
    }

    @Nonnull
    private ServiceOutcome<Field> getJiraField(String fieldId) {
        Field field = this.fieldManager.getField(fieldId);
        if (field == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.config.statistics.error.field.not.found", fieldId);
        }
        List<String> validFieldIds = this.getValidFieldIds();
        for (String validFieldId : validFieldIds) {
            if (!validFieldId.equals(field.getId())) continue;
            return ServiceOutcomeImpl.ok(field);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.statistics.error.field.not.found", fieldId);
    }
}

