/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.detailview;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfigurationService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldService;
import com.atlassian.jira.issue.fields.Field;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailViewFieldServiceImpl
implements DetailViewFieldService {
    private final DetailViewFieldConfigurationService configurationService;

    @Autowired
    public DetailViewFieldServiceImpl(DetailViewFieldConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public ServiceOutcome<List<? extends Field>> getDetailViewFields(@Nonnull RapidView rapidView) {
        Preconditions.checkNotNull((Object)rapidView, (Object)"rapidView");
        return ServiceOutcomes.map(this.configurationService.getDetailViewFields(rapidView), new Function<List<DetailViewFieldConfig>, List<? extends Field>>(){

            public List<? extends Field> apply(List<DetailViewFieldConfig> from) {
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(from, DetailViewFieldConfig.IS_VALID), DetailViewFieldConfig.TO_FIELD));
            }
        });
    }
}

