/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.detailview;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCFType;
import com.atlassian.greenhopper.customfield.sprint.SprintCFType;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.detailview.DetailViewField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfigurationService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailViewFieldConfigurationServiceImpl
implements DetailViewFieldConfigurationService {
    @Autowired
    private DetailViewFieldManager detailViewFieldManager;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    private final DetailViewFieldTransformer detailViewFieldTransformer = new DetailViewFieldTransformer();

    @Override
    public ServiceOutcome<List<DetailViewFieldConfig>> getDetailViewFields(@Nonnull RapidView rapidView) {
        ServiceOutcome<List<DetailViewField>> detailViewFields = this.detailViewFieldManager.getAll(rapidView);
        if (!detailViewFields.isValid()) {
            return ServiceOutcomeImpl.error(detailViewFields);
        }
        List<DetailViewField> nonDeletedFields = this.removeDeletedFields(rapidView, detailViewFields.getValue());
        List result = CollectionUtil.transform(nonDeletedFields, (Function)this.detailViewFieldTransformer);
        return ServiceOutcomeImpl.ok(result);
    }

    @Nonnull
    private List<DetailViewField> removeDeletedFields(final @Nonnull RapidView rapidView, @Nonnull List<DetailViewField> fields) {
        return Lists.newArrayList((Iterable)Iterables.filter(fields, (Predicate)new Predicate<DetailViewField>(){

            public boolean apply(@Nullable DetailViewField detailViewField) {
                boolean inDatabase;
                if (detailViewField == null) {
                    return false;
                }
                Field field = DetailViewFieldConfigurationServiceImpl.this.fieldManager.getField(detailViewField.getFieldId());
                if (field == null && !(inDatabase = DetailViewFieldConfigurationServiceImpl.this.customFieldService.verifyCustomFieldExistsInDB(detailViewField.getFieldId()))) {
                    DetailViewFieldConfigurationServiceImpl.this.detailViewFieldManager.delete(rapidView, detailViewField.getId());
                    return false;
                }
                return true;
            }
        }));
    }

    @Override
    public ServiceOutcome<List<? extends Field>> getAvailableDetailViewCustomFields() {
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        customFields.addAll(this.customFieldService.getCustomFields(GenericTextCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(NumberCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(DateCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(DateTimeCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(UserCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(MultiUserCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(MultiGroupCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(LabelsCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(SelectCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(MultiSelectCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(VersionCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(CascadingSelectCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(EpicLinkCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(LexoRankCFType.class, false));
        customFields.addAll(this.customFieldService.getCustomFields(SprintCFType.class, false));
        return ServiceOutcomeImpl.ok(customFields);
    }

    @Override
    public ServiceOutcome<List<? extends Field>> getAvailableDetailViewFields(@Nonnull RapidView rapidView) {
        ServiceOutcome<List<? extends Field>> availableCustomFields = this.getAvailableDetailViewCustomFields();
        if (!availableCustomFields.isValid()) {
            return ServiceOutcomeImpl.error(availableCustomFields);
        }
        List<? extends Field> availableSystemFields = this.getAvailableSystemFieldsForDetailView();
        ServiceOutcome<List<DetailViewFieldConfig>> current = this.getDetailViewFields(rapidView);
        if (!current.isValid()) {
            return ServiceOutcomeImpl.error(current);
        }
        HashSet<String> currentIds = new HashSet<String>();
        for (DetailViewFieldConfig detailViewFieldConfig : current.getValue()) {
            if (!detailViewFieldConfig.isValid()) continue;
            currentIds.add(detailViewFieldConfig.getJiraField().getId());
        }
        StatisticsField estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView);
        CustomField epicNameField = this.epicCustomFieldService.getDefaultEpicLabelField();
        CustomField epicColorField = this.epicCustomFieldService.getDefaultEpicColorField();
        CustomField epicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        ArrayList<Field> availableForView = new ArrayList<Field>();
        Iterable fields = Iterables.concat((Iterable)availableCustomFields.getValue(), availableSystemFields);
        for (Field field : fields) {
            if (field.equals(estimateStatistic.getField()) || field.getId().equals(epicNameField.getId()) || field.getId().equals(epicColorField.getId()) || field instanceof CustomField && ((CustomField)field).getCustomFieldType() instanceof EpicLinkCFType && !field.getId().equals(epicLinkField.getId()) || currentIds.contains(field.getId())) continue;
            availableForView.add(field);
        }
        return ServiceOutcomeImpl.ok(availableForView);
    }

    public List<? extends Field> getAvailableSystemFieldsForDetailView() {
        ArrayList<Object> availableSystemFields = new ArrayList<Object>();
        availableSystemFields.addAll(this.getDefaultSystemFieldsForDetailView());
        availableSystemFields.add(this.fieldManager.getField("resolution"));
        availableSystemFields.add(this.fieldManager.getField("environment"));
        availableSystemFields.add(this.fieldManager.getField("security"));
        availableSystemFields.add(this.fieldManager.getField("duedate"));
        availableSystemFields.add(this.fieldManager.getField("resolutiondate"));
        availableSystemFields.add(this.fieldManager.getField("votes"));
        availableSystemFields.add(this.fieldManager.getField("priority"));
        availableSystemFields.add(this.fieldManager.getField("issuetype"));
        return availableSystemFields;
    }

    public List<? extends Field> getDefaultSystemFieldsForDetailView() {
        ArrayList<Field> availableSystemFields = new ArrayList<Field>();
        availableSystemFields.add(this.fieldManager.getField("status"));
        availableSystemFields.add(this.fieldManager.getField("priority"));
        availableSystemFields.add(this.fieldManager.getField("components"));
        availableSystemFields.add(this.fieldManager.getField("labels"));
        availableSystemFields.add(this.fieldManager.getField("versions"));
        availableSystemFields.add(this.fieldManager.getField("fixVersions"));
        availableSystemFields.add(this.fieldManager.getField("issuelinks"));
        availableSystemFields.add(this.fieldManager.getField("reporter"));
        availableSystemFields.add(this.fieldManager.getField("assignee"));
        availableSystemFields.add(this.fieldManager.getField("created"));
        availableSystemFields.add(this.fieldManager.getField("updated"));
        return availableSystemFields;
    }

    @Override
    public ServiceOutcome<List<DetailViewFieldConfig>> add(ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull DetailViewField detailViewField) {
        ServiceOutcome<Void> permission = this.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        ServiceOutcome<Void> validateAdd = this.validateFieldForAdd(rapidView, detailViewField);
        if (!validateAdd.isValid()) {
            return ServiceOutcomeImpl.error(validateAdd);
        }
        ServiceOutcome<DetailViewField> addResult = this.detailViewFieldManager.add(rapidView, detailViewField);
        if (!addResult.isValid()) {
            return ServiceOutcomeImpl.error(addResult);
        }
        return this.getDetailViewFields(rapidView);
    }

    @Override
    public ServiceOutcome<Void> delete(ApplicationUser user, RapidView rapidView, Long detailViewFieldId) {
        ServiceOutcome<Void> permission = this.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        return this.detailViewFieldManager.delete(rapidView, detailViewFieldId);
    }

    @Override
    public ServiceOutcome<Void> moveAfter(ApplicationUser user, RapidView rapidView, long detailViewFieldId, Long moveToDetailViewFieldId) {
        ServiceOutcome<Void> permission = this.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        return this.detailViewFieldManager.moveAfter(rapidView, detailViewFieldId, moveToDetailViewFieldId);
    }

    @Override
    public ServiceOutcome<List<DetailViewField>> createDefaultRapidViewFields(ApplicationUser user, RapidView rapidView) {
        List<? extends Field> fields = this.getDefaultSystemFieldsForDetailView();
        fields.add((Field)this.epicCustomFieldService.getDefaultEpicLinkField());
        ArrayList<DetailViewField> mappedFields = new ArrayList<DetailViewField>();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            mappedFields.add(DetailViewField.builder().fieldId(field.getId()).position(i).build());
        }
        return this.detailViewFieldManager.set(rapidView, mappedFields);
    }

    private ServiceOutcome<Void> validateFieldForAdd(RapidView rapidView, DetailViewField detailViewField) {
        if (StringUtils.isBlank((String)detailViewField.getFieldId())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.detailview.error.no.field", new Object[0]);
        }
        ServiceOutcome<List<? extends Field>> availableDetailViewFields = this.getAvailableDetailViewFields(rapidView);
        if (!availableDetailViewFields.isValid()) {
            return ServiceOutcomeImpl.error(availableDetailViewFields);
        }
        boolean isValid = false;
        for (Field field : availableDetailViewFields.getValue()) {
            if (!field.getId().equals(detailViewField.getFieldId())) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.detailview.error.field.not.valid", detailViewField.getFieldId());
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<Void> validateModifyPermission(ApplicationUser user, RapidView rapidView) {
        if (!this.rapidViewPermissionService.canEdit(user, rapidView)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.config.detailview.error.no.permission", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    private class DetailViewFieldTransformer
    implements Function<DetailViewField, DetailViewFieldConfig> {
        private DetailViewFieldTransformer() {
        }

        public DetailViewFieldConfig apply(DetailViewField detailViewField) {
            CustomField customField = DetailViewFieldConfigurationServiceImpl.this.customFieldService.getCustomField(detailViewField.getFieldId());
            if (customField != null) {
                return DetailViewFieldConfig.forValidField(detailViewField, (Field)customField);
            }
            Field field = DetailViewFieldConfigurationServiceImpl.this.fieldManager.getField(detailViewField.getFieldId());
            if (field != null) {
                return DetailViewFieldConfig.forValidField(detailViewField, field);
            }
            return DetailViewFieldConfig.forInvalidField(detailViewField);
        }
    }
}

