/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.detailview;

import com.atlassian.greenhopper.model.rapid.detailview.DetailViewField;
import com.atlassian.jira.issue.fields.Field;
import com.google.common.base.Function;
import com.google.common.base.Predicate;

public class DetailViewFieldConfig {
    private final DetailViewField detailViewField;
    private final boolean isValid;
    private final Field jiraField;
    public static Predicate<DetailViewFieldConfig> IS_VALID = new Predicate<DetailViewFieldConfig>(){

        public boolean apply(DetailViewFieldConfig config) {
            return config.isValid();
        }
    };
    public static Function<DetailViewFieldConfig, Field> TO_FIELD = new Function<DetailViewFieldConfig, Field>(){

        public Field apply(DetailViewFieldConfig config) {
            return config.getJiraField();
        }
    };

    private DetailViewFieldConfig(DetailViewField detailViewField, boolean valid, Field jiraField) {
        this.detailViewField = detailViewField;
        this.isValid = valid;
        this.jiraField = jiraField;
    }

    public static DetailViewFieldConfig forValidField(DetailViewField detailViewField, Field jiraField) {
        return new DetailViewFieldConfig(detailViewField, true, jiraField);
    }

    public static DetailViewFieldConfig forInvalidField(DetailViewField detailViewField) {
        return new DetailViewFieldConfig(detailViewField, false, null);
    }

    public DetailViewField getDetailViewField() {
        return this.detailViewField;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Field getJiraField() {
        return this.jiraField;
    }
}

