/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.color;

import com.atlassian.greenhopper.manager.color.CardColorManager;
import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorServiceImpl
implements CardColorService {
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private CardColorManager cardColorManager;

    @Override
    public ServiceOutcome<List<CardColor>> getAll(ApplicationUser user, RapidView rapidView) {
        return this.cardColorManager.getAll(rapidView);
    }

    @Override
    public ServiceOutcome<List<CardColor>> getForStrategy(ApplicationUser user, RapidView rapidView, CardColorStrategy strategy) {
        ServiceOutcome<List<CardColor>> colorOutcome = this.getAll(user, rapidView);
        if (!colorOutcome.isValid()) {
            return ServiceOutcomeImpl.error(colorOutcome);
        }
        List<CardColor> colors = colorOutcome.getValue();
        Iterator<CardColor> it = colors.iterator();
        while (it.hasNext()) {
            if (it.next().getStrategy().equals((Object)strategy)) continue;
            it.remove();
        }
        return ServiceOutcomeImpl.ok(colors);
    }

    @Override
    public ServiceOutcome<CardColor> get(ApplicationUser user, RapidView rapidView, long cardColorId) {
        return this.cardColorManager.get(rapidView, cardColorId);
    }

    @Override
    public ServiceOutcome<CardColor> add(ApplicationUser user, RapidView rapidView, CardColor cardColor) {
        ServiceOutcome<Void> hasPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!hasPermission.isValid()) {
            return ServiceOutcomeImpl.error(hasPermission);
        }
        ServiceOutcome<Void> validated = this.validateCardColor(user, cardColor);
        if (!validated.isValid()) {
            return ServiceOutcomeImpl.error(validated);
        }
        return this.cardColorManager.add(rapidView, cardColor);
    }

    @Override
    public ServiceOutcome<CardColor> update(ApplicationUser user, RapidView rapidView, CardColor cardColor) {
        ServiceOutcome<Void> hasPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!hasPermission.isValid()) {
            return ServiceOutcomeImpl.error(hasPermission);
        }
        ServiceOutcome<Void> validated = this.validateCardColor(user, cardColor);
        if (!validated.isValid()) {
            return ServiceOutcomeImpl.error(validated);
        }
        return this.cardColorManager.update(rapidView, cardColor);
    }

    @Override
    public ServiceOutcome<List<CardColor>> set(ApplicationUser user, RapidView rapidView, List<CardColor> cardColors) {
        ServiceOutcome<Void> hasPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!hasPermission.isValid()) {
            return ServiceOutcomeImpl.error(hasPermission);
        }
        for (CardColor cardColor : cardColors) {
            ServiceOutcome<Void> validated = this.validateCardColor(user, cardColor);
            if (validated.isValid()) continue;
            return ServiceOutcomeImpl.error(validated);
        }
        return this.cardColorManager.set(rapidView, cardColors);
    }

    @Override
    public ServiceOutcome<Void> delete(ApplicationUser user, RapidView rapidView, long cardColorId) {
        ServiceOutcome<Void> hasPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!hasPermission.isValid()) {
            return ServiceOutcomeImpl.error(hasPermission);
        }
        return this.cardColorManager.delete(rapidView, cardColorId);
    }

    @Override
    public ServiceOutcome<Void> moveAfter(ApplicationUser user, RapidView rapidView, long cardColorId, Long moveToCardColorId) {
        ServiceOutcome<Void> hasPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!hasPermission.isValid()) {
            return ServiceOutcomeImpl.error(hasPermission);
        }
        return this.cardColorManager.moveAfter(rapidView, cardColorId, moveToCardColorId);
    }

    private ServiceOutcome<Void> validateCardColor(ApplicationUser user, CardColor cardColor) {
        return ServiceOutcomeImpl.ok();
    }
}

