/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.color;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.color.CardColorManager;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.query.QueryUtils;
import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueIdNumericCollector;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.color.AbstractCardColorCallback;
import com.atlassian.greenhopper.service.rapid.view.color.AssigneeCardColorCallback;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorPalette;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorQueryService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorService;
import com.atlassian.greenhopper.service.rapid.view.color.IssueTypeCardColorCallback;
import com.atlassian.greenhopper.service.rapid.view.color.PriorityCardColorCallback;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.optimizers.DeterminedProjectsExtractor;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorQueryServiceImpl
implements CardColorQueryService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    CardColorService cardColorService;
    @Autowired
    CardColorManager cardColorManager;
    @Autowired
    CardColorPalette cardColorPalette;
    @Autowired
    RapidViewQueryService rapidViewQueryService;
    @Autowired
    JqlQueryParser jqlQueryParser;
    @Autowired
    IssueDataService issueDataService;
    @Autowired
    ConstantsManager constantsManager;
    @Autowired
    IssueManager issueManager;
    protected final LoggerWrapper performanceLogger = LoggerWrapper.with("com.atlassian.greenhopper.performance");

    @Override
    public boolean supportsIssueDataCallback(CardColorStrategy strategy) {
        return CardColorStrategy.CUSTOM != strategy && CardColorStrategy.NONE != strategy;
    }

    @Override
    public ServiceOutcome<Map<Long, CardColor>> getCardColorsForQuery(ApplicationUser user, RapidView rapidView, CardColorStrategy cardColorStrategy, Query query, int maxVisitedIssues) {
        if (cardColorStrategy.equals((Object)CardColorStrategy.CUSTOM)) {
            return this.getCustomStrategyIssueCardColors(user, rapidView, query, maxVisitedIssues);
        }
        return this.getCallbackSupportedIssueCardColors(user, rapidView, cardColorStrategy, query);
    }

    @Override
    public ServiceOutcome<Map<Long, CardColor>> getCardColorsForIssues(ApplicationUser user, RapidView rapidView, List<Long> issueIds) {
        Clause boardClause = this.rapidViewQueryService.getRapidViewQuery(user, rapidView).get().getWhereClause();
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().issue().in(issueIds.toArray(new Long[0]));
        if (boardClause != null) {
            DeterminedProjectsExtractor extractor = new DeterminedProjectsExtractor();
            Set projectKeys = extractor.extractDeterminedProjectsFromClause(boardClause);
            if (projectKeys.size() > 0) {
                builder.and().project(projectKeys.toArray(new String[0]));
            } else {
                this.processIssues(issueIds, builder);
            }
        } else {
            this.processIssues(issueIds, builder);
        }
        return this.getCardColorsForQuery(user, rapidView, rapidView.getCardColorStrategy(), builder.buildQuery(), issueIds.size());
    }

    @Override
    public ServiceOutcome<Map<Long, CardColor>> getCardColorsForIssues(ApplicationUser user, RapidView rapidView) {
        return this.getCardColorsForQuery(user, rapidView, rapidView.getCardColorStrategy(), this.rapidViewQueryService.getRapidViewQuery(user, rapidView).get(), Integer.MAX_VALUE);
    }

    private void processIssues(List<Long> issueIds, JqlClauseBuilder builder) {
        Long[] projectIds = (Long[])issueIds.stream().map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0)).filter(Objects::nonNull).map(Issue::getProjectId).filter(Objects::nonNull).distinct().toArray(Long[]::new);
        if (projectIds.length > 0) {
            builder.and().project(projectIds);
        }
    }

    private ServiceOutcome<Map<Long, CardColor>> getCallbackSupportedIssueCardColors(ApplicationUser user, RapidView rapidView, CardColorStrategy cardColorStrategy, Query query) {
        long start = System.currentTimeMillis();
        ServiceOutcome<AbstractCardColorCallback> cardColorCallback = this.createCardColorCallback(user, rapidView, cardColorStrategy);
        if (!cardColorCallback.isValid()) {
            return ServiceOutcomeImpl.error(cardColorCallback);
        }
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, query, (IssueDataCallback)cardColorCallback.getValue());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        this.perfLog("card.color.query.service.get.custom", start);
        return ServiceOutcomeImpl.ok(cardColorCallback.getValue().getCardColorsForIssues());
    }

    private ServiceOutcome<Map<Long, CardColor>> getCustomStrategyIssueCardColors(ApplicationUser user, RapidView rapidView, Query query, int maxVisitedIssues) {
        long start = System.currentTimeMillis();
        ServiceOutcome<List<CardColor>> cardColors = this.cardColorService.getForStrategy(user, rapidView, CardColorStrategy.CUSTOM);
        if (!cardColors.isValid()) {
            return ServiceOutcomeImpl.error(cardColors);
        }
        JqlQueryBuilder builder = QueryUtils.clearOrderByClause(query);
        HashMap<Long, CardColor> issueIdToColor = new HashMap<Long, CardColor>();
        for (CardColor cardColor : cardColors.get()) {
            IssueIdNumericCollector issueIdCollector = new IssueIdNumericCollector();
            ServiceOutcome<ClauseToAdd> cardColorClause = this.getCardColorClause(cardColor);
            if (!cardColorClause.isValid()) {
                return ServiceOutcomeImpl.error(cardColorClause);
            }
            JqlQueryBuilder cardColorQuery = QueryUtils.addClauses(builder.buildQuery(), cardColorClause.getValue());
            ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, cardColorQuery.buildQuery(), issueIdCollector);
            if (!outcome.isValid()) {
                return ServiceOutcomeImpl.error(outcome);
            }
            for (Long issueId : issueIdCollector.getNumericIssueIds()) {
                issueIdToColor.putIfAbsent(issueId, cardColor);
            }
            if (issueIdToColor.size() < maxVisitedIssues && cardColorClause.get().hasClause()) continue;
            break;
        }
        this.perfLog("card.color.query.service.get.callback", start);
        return ServiceOutcomeImpl.ok(issueIdToColor);
    }

    private ServiceOutcome<ClauseToAdd> getCardColorClause(CardColor cardColor) {
        try {
            Clause swimlaneClause = this.jqlQueryParser.parseQuery(cardColor.getValue()).getWhereClause();
            return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(swimlaneClause));
        }
        catch (JqlParseException e) {
            this.log.warn("Unable to parse card color query, cardcolor=%s, query:%s", cardColor.getId(), cardColor.getValue());
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.config.cardcolors.query.invalid", new Object[0]);
        }
    }

    @Override
    public ServiceOutcome<RapidIssueEntryCallbackComponent> createCardColorIssueEntryCallback(ApplicationUser user, RapidView rapidView, CardColorStrategy cardColorStrategy) {
        ServiceOutcome<AbstractCardColorCallback> callback = this.createCardColorCallback(user, rapidView, cardColorStrategy);
        if (!callback.isValid()) {
            return ServiceOutcomeImpl.error(callback);
        }
        return ServiceOutcomeImpl.ok(callback.getValue());
    }

    private ServiceOutcome<AbstractCardColorCallback> createCardColorCallback(ApplicationUser user, RapidView rapidView, CardColorStrategy cardColorStrategy) {
        if (!this.supportsIssueDataCallback(cardColorStrategy)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Strategy not supported by the issue index", new Object[0]);
        }
        ServiceOutcome<List<CardColor>> colors = this.cardColorService.getForStrategy(user, rapidView, cardColorStrategy);
        if (!colors.isValid()) {
            return ServiceOutcomeImpl.error(colors);
        }
        switch (cardColorStrategy) {
            case ASSIGNEE: {
                return ServiceOutcomeImpl.ok(new AssigneeCardColorCallback(rapidView, this.cardColorManager, this.cardColorPalette, colors.getValue()));
            }
            case ISSUE_TYPE: {
                return ServiceOutcomeImpl.ok(new IssueTypeCardColorCallback(rapidView, this.cardColorManager, this.cardColorPalette, colors.getValue()));
            }
            case PRIORITY: {
                return ServiceOutcomeImpl.ok(new PriorityCardColorCallback(rapidView, this.cardColorManager, this.cardColorPalette, colors.getValue()));
            }
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Can't find callback for strategy", new Object[0]);
    }

    @Override
    public ServiceOutcome<Void> queryAndAttributeColorSettingsForBoard(ApplicationUser user, RapidView rapidView, CardColorStrategy cardColorStrategy) {
        if (cardColorStrategy.equals((Object)CardColorStrategy.CUSTOM)) {
            return ServiceOutcomeImpl.ok();
        }
        if (cardColorStrategy.equals((Object)CardColorStrategy.PRIORITY)) {
            return this.attributePriorityValuesForBoard(user, rapidView);
        }
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        ServiceOutcome<AbstractCardColorCallback> component = this.createCardColorCallback(user, rapidView, cardColorStrategy);
        if (!component.isValid()) {
            return ServiceOutcomeImpl.error(component);
        }
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, rapidViewQuery.getValue(), (IssueDataCallback)component.getValue());
        return outcome;
    }

    private ServiceOutcome<Void> attributePriorityValuesForBoard(ApplicationUser user, RapidView rapidView) {
        ArrayList priorities = new ArrayList(this.constantsManager.getPriorityObjects());
        Collections.reverse(priorities);
        ServiceOutcome<List<CardColor>> colors = this.cardColorService.getForStrategy(user, rapidView, CardColorStrategy.PRIORITY);
        if (!colors.isValid()) {
            return ServiceOutcomeImpl.error(colors);
        }
        for (Priority priority : priorities) {
            if (this.hasColorForValue(colors.get(), priority.getId())) continue;
            Color color = this.cardColorPalette.getDefaultColorForPriority(priority);
            CardColor cardColor = CardColor.builder().color(color).strategy(CardColorStrategy.PRIORITY).value(priority.getId()).build();
            ServiceOutcome<CardColor> addColorOutcome = this.cardColorService.add(user, rapidView, cardColor);
            if (addColorOutcome.isValid()) continue;
            return ServiceOutcomeImpl.error(addColorOutcome);
        }
        return ServiceOutcomeImpl.ok();
    }

    private boolean hasColorForValue(List<CardColor> colors, String value) {
        for (CardColor color : colors) {
            if (!color.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    private void perfLog(String message, long start) {
        if (!this.performanceLogger.isDebugEnabled()) {
            return;
        }
        try {
            this.performanceLogger.debug(message + "  %dms", System.currentTimeMillis() - start);
        }
        catch (RuntimeException e) {
            this.performanceLogger.error("Unable to format message: " + message, new Object[0]);
            this.performanceLogger.exception(e);
        }
    }
}

