/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.color;

import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.priority.Priority;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorPalette {
    @Autowired
    ConstantsManager constantsManager;
    private Color fallback;
    private Color[] defaultValues;

    public CardColorPalette() {
        this.initializeColors();
    }

    private void initializeColors() {
        this.fallback = new Color(238, 238, 238);
        this.defaultValues = new Color[20];
        this.defaultValues[0] = new Color(204, 0, 0);
        this.defaultValues[1] = new Color(255, 153, 51);
        this.defaultValues[2] = new Color(191, 228, 255);
        this.defaultValues[3] = new Color(0, 153, 0);
        this.defaultValues[4] = new Color(0, 153, 153);
        this.defaultValues[5] = new Color(255, 214, 0);
        this.defaultValues[6] = new Color(102, 204, 51);
        this.defaultValues[7] = new Color(204, 51, 102);
        this.defaultValues[8] = new Color(153, 0, 153);
        this.defaultValues[9] = new Color(191, 155, 30);
        this.defaultValues[10] = new Color(141, 201, 203);
        this.defaultValues[11] = new Color(177, 71, 202);
        this.defaultValues[12] = new Color(179, 242, 144);
        this.defaultValues[13] = new Color(204, 203, 107);
        this.defaultValues[14] = new Color(141, 104, 17);
        this.defaultValues[15] = new Color(141, 202, 253);
        this.defaultValues[16] = new Color(182, 109, 56);
        this.defaultValues[17] = new Color(221, 78, 104);
        this.defaultValues[18] = new Color(131, 30, 7);
        this.defaultValues[19] = new Color(136, 135, 32);
    }

    public List<Color> getDefaultColors() {
        return Arrays.asList(this.defaultValues);
    }

    public Color getDefaultColorForIssueType(int issueTypeId) {
        if (issueTypeId < 1) {
            issueTypeId = 1;
        }
        int index = (issueTypeId - 1) % this.defaultValues.length;
        return this.defaultValues[index];
    }

    public Color getDefaultColor(Collection<CardColor> existingColors) {
        int index = existingColors.size() % this.defaultValues.length;
        return this.defaultValues[index];
    }

    public Color getDefaultColorForPriority(String priorityId) {
        Priority priorityObject = this.constantsManager.getPriorityObject(priorityId);
        if (priorityObject != null) {
            return this.getDefaultColorForPriority(priorityObject);
        }
        return this.getFallback();
    }

    public Color getDefaultColorForPriority(Priority priorityObject) {
        String color = priorityObject.getStatusColor();
        return Color.decode(color);
    }

    public Color getFallback() {
        return this.fallback;
    }
}

