/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.color;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.color.CardColorManager;
import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorPalette;
import com.atlassian.greenhopper.util.ColorUtils;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import io.atlassian.fugue.Option;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;

public abstract class AbstractCardColorCallback
implements IssueDataCallback,
RapidIssueEntryCallbackComponent {
    private LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    private CardColorManager cardColorManager;
    private CardColorPalette cardColorPalette;
    private RapidView rapidView;
    private CardColorStrategy strategy;
    private String documentField;
    private Map<String, CardColor> idToColor;
    private Map<Long, CardColor> issueIdsToCardColors;

    public AbstractCardColorCallback(RapidView rapidView, CardColorManager cardColorManager, CardColorPalette cardColorPalette, CardColorStrategy strategy, String documentField, List<CardColor> colors) {
        this.cardColorManager = cardColorManager;
        this.rapidView = rapidView;
        this.cardColorPalette = cardColorPalette;
        this.strategy = strategy;
        this.documentField = documentField;
        this.idToColor = new HashMap<String, CardColor>();
        for (CardColor color : colors) {
            String value = color.getValue();
            if (value == null) {
                value = "";
            }
            this.idToColor.put(value, color);
        }
        this.issueIdsToCardColors = new HashMap<Long, CardColor>();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(this.documentField);
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        CardColor colorById;
        if (fieldName.equals(this.documentField) && (colorById = this.findByValue(data)) != null) {
            this.issueIdsToCardColors.put(issueId, colorById);
        }
    }

    @Override
    public boolean requiresIssueDoc() {
        return false;
    }

    @Override
    public void issueComplete(Long issueId, String issueKey, Option<Document> issueDoc) {
    }

    public Map<Long, CardColor> getCardColorsForIssues() {
        return this.issueIdsToCardColors;
    }

    @Override
    public void processFieldData(Long issueId, String issueKey, IssueFieldValueProvider data, RapidIssueEntry entry) {
        String value = data.get(this.documentField);
        CardColor colorById = this.findByValue(value);
        if (colorById != null) {
            entry.color = ColorUtils.colorToHex(colorById.getColor());
        }
    }

    protected CardColor findByValue(String value) {
        return this.findColorById(value);
    }

    protected CardColor findColorById(String id) {
        CardColor color = this.idToColor.get(id);
        if (color != null) {
            return color;
        }
        ServiceOutcome<CardColor> createdColor = this.createMissingCardColor(this.rapidView, this.strategy, this.idToColor.values(), id);
        if (createdColor.isValid()) {
            this.idToColor.put(createdColor.getValue().getValue(), createdColor.getValue());
            return createdColor.getValue();
        }
        this.logger.warn("Unable to create card color for value %s", id);
        return null;
    }

    private ServiceOutcome<CardColor> createMissingCardColor(RapidView rapidView, CardColorStrategy strategy, Collection<CardColor> existingColors, String value) {
        this.logger.debug("Creating new card color for rapidView %s, strategy %s and value %s", rapidView.getId(), strategy.getId(), value);
        Color newColor = null;
        switch (strategy) {
            case ISSUE_TYPE: {
                Integer issueTypeId = NumberUtils.toInteger(value);
                if (issueTypeId == null) {
                    issueTypeId = 1;
                }
                newColor = this.cardColorPalette.getDefaultColorForIssueType(issueTypeId);
                break;
            }
            case PRIORITY: {
                newColor = this.cardColorPalette.getDefaultColorForPriority(value);
                break;
            }
            default: {
                newColor = this.cardColorPalette.getDefaultColor(existingColors);
            }
        }
        CardColor color = CardColor.builder().color(newColor).strategy(strategy).value(value).build();
        return this.cardColorManager.add(rapidView, color);
    }
}

