/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.cardlayout;

import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfigurationService;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldService;
import com.atlassian.jira.issue.fields.NavigableField;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardLayoutFieldServiceImpl
implements CardLayoutFieldService {
    @Autowired
    private CardLayoutFieldConfigurationService configurationService;

    @Override
    public ServiceOutcome<List<NavigableField>> getCardLayoutFields(@Nonnull RapidView rapidView, @Nonnull CardLayoutField.Mode mode) {
        Preconditions.checkNotNull((Object)rapidView, (Object)"rapidView");
        Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode");
        ServiceOutcome<List<CardLayoutFieldConfig>> cardLayoutFieldConfigs = this.configurationService.getCardLayoutFields(rapidView, mode);
        if (!cardLayoutFieldConfigs.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFieldConfigs);
        }
        Iterable validConfigs = Iterables.filter((Iterable)cardLayoutFieldConfigs.getValue(), CardLayoutFieldConfig.IS_VALID);
        Iterable validFields = Iterables.transform((Iterable)validConfigs, CardLayoutFieldConfig.TO_FIELD);
        return ServiceOutcomeImpl.ok(ImmutableList.copyOf((Iterable)validFields));
    }
}

