/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.cardlayout;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.epiccolor.EpicColorCFType;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelCFType;
import com.atlassian.greenhopper.customfield.epicstatus.EpicStatusCFType;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCFType;
import com.atlassian.greenhopper.customfield.rank.RankCFType;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutManager;
import com.atlassian.greenhopper.manager.issue.fields.FlagCustomFieldProvider;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfigurationService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pyxis.greenhopper.jira.customfields.ReleasedVersionHistoryCFType;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardLayoutFieldConfigurationServiceImpl
implements CardLayoutFieldConfigurationService {
    private static final int MAX_FIELDS_PER_MODE = 3;
    private static final String CARD_LAYOUT_CONFIGURATION_CONTEXT = "cardlayoutConfig";
    @Autowired
    private CardLayoutManager cardLayoutManager;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private FlagCustomFieldProvider flagCustomFieldProvider;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private SearchService jiraSearchService;

    @Override
    public ServiceOutcome<List<CardLayoutFieldConfig>> getCardLayoutFields(@Nonnull RapidView rapidView) {
        ServiceOutcome<List<CardLayoutField>> cardLayoutFields = this.getCardLayoutFieldList(rapidView);
        if (!cardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFields);
        }
        return ServiceOutcomeImpl.ok(this.toCardLayoutFieldConfigList(cardLayoutFields.getValue()));
    }

    @Override
    public ServiceOutcome<List<CardLayoutFieldConfig>> getCardLayoutFields(@Nonnull RapidView rapidView, final @Nonnull CardLayoutField.Mode mode) {
        ServiceOutcome<List<CardLayoutField>> cardLayoutFields = this.getCardLayoutFieldList(rapidView);
        if (!cardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFields);
        }
        Iterable cardLayoutFieldsForMode = Iterables.filter((Iterable)cardLayoutFields.getValue(), (Predicate)new Predicate<CardLayoutField>(){

            public boolean apply(@Nullable CardLayoutField cardLayoutField) {
                return cardLayoutField.getMode().equals((Object)mode);
            }
        });
        return ServiceOutcomeImpl.ok(this.toCardLayoutFieldConfigList(Lists.newArrayList((Iterable)cardLayoutFieldsForMode)));
    }

    @Override
    public ServiceOutcome<Set<Field>> getAvailableCardLayoutFields(@Nonnull ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull CardLayoutField.Mode mode) {
        Set navigableFields;
        ServiceOutcome<Boolean> maxReached = this.isMaxCardLayoutFieldsForModeLimitReached(rapidView, mode);
        if (!maxReached.isValid()) {
            return ServiceOutcomeImpl.error(maxReached);
        }
        if (maxReached.getValue().booleanValue()) {
            return ServiceOutcomeImpl.ok(new HashSet());
        }
        final ServiceOutcome<Collection<String>> configuredFieldsIds = this.getConfiguredCardLayoutFieldIds(rapidView, mode);
        if (!configuredFieldsIds.isValid()) {
            return ServiceOutcomeImpl.error(configuredFieldsIds);
        }
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (rapidViewQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        QueryContext queryContext = this.jiraSearchService.getSimpleQueryContext(user, rapidViewQuery.getValue());
        try {
            navigableFields = this.fieldManager.getAvailableNavigableFieldsWithScope(user, queryContext);
        }
        catch (FieldException fieldException) {
            throw new DataAccessException((Throwable)fieldException);
        }
        Iterable availabelFields = Iterables.filter((Iterable)navigableFields, (Predicate)new Predicate<NavigableField>(){

            public boolean apply(@Nullable NavigableField navigableField) {
                return !((Collection)configuredFieldsIds.getValue()).contains(navigableField.getId()) && !CardLayoutFieldConfigurationServiceImpl.this.isFieldExcluded(navigableField);
            }
        });
        return ServiceOutcomeImpl.ok(Sets.newHashSet((Iterable)availabelFields));
    }

    @Override
    public ServiceOutcome<CardLayoutFieldConfig> add(@Nonnull ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull CardLayoutField cardLayoutField) {
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        ServiceOutcome<Void> validateAdd = this.validateFieldForAdd(user, rapidView, cardLayoutField);
        if (!validateAdd.isValid()) {
            return ServiceOutcomeImpl.error(validateAdd);
        }
        ServiceOutcome<CardLayoutField> addResult = this.cardLayoutManager.add(rapidView, cardLayoutField);
        if (!addResult.isValid()) {
            return ServiceOutcomeImpl.error(addResult);
        }
        return ServiceOutcomeImpl.ok(this.toCardLayoutFieldConfig(addResult.getValue()));
    }

    @Override
    public ServiceOutcome<Void> delete(@Nonnull ApplicationUser user, @Nonnull RapidView rapidView, long cardLayoutFieldId) {
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        return this.cardLayoutManager.delete(rapidView, cardLayoutFieldId);
    }

    @Override
    public ServiceOutcome<Void> moveAfter(@Nonnull ApplicationUser user, @Nonnull RapidView rapidView, long fieldIdToMove, @Nonnull Option<Long> optionalFieldIdToMoveAfter) {
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        return this.cardLayoutManager.moveAfter(rapidView, fieldIdToMove, optionalFieldIdToMoveAfter);
    }

    private ServiceOutcome<Collection<String>> getConfiguredCardLayoutFieldIds(RapidView rapidView, CardLayoutField.Mode mode) {
        ServiceOutcome<List<CardLayoutFieldConfig>> cardLayoutFields = this.getCardLayoutFields(rapidView, mode);
        if (!cardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFields);
        }
        ArrayList cardLayoutFieldIds = Lists.newArrayList((Iterable)Iterables.transform((Iterable)cardLayoutFields.getValue(), (Function)new Function<CardLayoutFieldConfig, String>(){

            public String apply(@Nullable CardLayoutFieldConfig cardLayoutFieldConfig) {
                return cardLayoutFieldConfig.getCardLayoutField().getFieldId();
            }
        }));
        return ServiceOutcomeImpl.ok(cardLayoutFieldIds);
    }

    @Nonnull
    private ServiceOutcome<List<CardLayoutField>> getCardLayoutFieldList(@Nonnull RapidView rapidView) {
        ServiceOutcome<List<CardLayoutField>> cardLayoutFields = this.cardLayoutManager.getAll(rapidView);
        if (!cardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFields);
        }
        List<CardLayoutField> cardLayoutFieldList = cardLayoutFields.getValue();
        cardLayoutFieldList = this.removeDeletedFields(rapidView, cardLayoutFieldList);
        return ServiceOutcomeImpl.ok(cardLayoutFieldList);
    }

    @Nonnull
    private List<CardLayoutField> removeDeletedFields(final @Nonnull RapidView rapidView, @Nullable List<CardLayoutField> cardLayoutFieldList) {
        if (cardLayoutFieldList == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Iterables.filter(cardLayoutFieldList, (Predicate)new Predicate<CardLayoutField>(){

            public boolean apply(@Nullable CardLayoutField field) {
                boolean inDatabase;
                if (field == null) {
                    return false;
                }
                Field customField = CardLayoutFieldConfigurationServiceImpl.this.fieldManager.getField(field.getFieldId());
                if (customField == null && !(inDatabase = CardLayoutFieldConfigurationServiceImpl.this.customFieldService.verifyCustomFieldExistsInDB(field.getFieldId()))) {
                    CardLayoutFieldConfigurationServiceImpl.this.cardLayoutManager.delete(rapidView, field.getId());
                    return false;
                }
                return true;
            }
        }));
    }

    private ServiceOutcome<Boolean> isMaxCardLayoutFieldsForModeLimitReached(RapidView rapidView, CardLayoutField.Mode mode) {
        ServiceOutcome<List<CardLayoutFieldConfig>> current = this.getCardLayoutFields(rapidView, mode);
        if (!current.isValid()) {
            return ServiceOutcomeImpl.error(current);
        }
        return ServiceOutcomeImpl.ok(current.getValue().size() >= 3);
    }

    private ServiceOutcome<Void> validateFieldForAdd(ApplicationUser user, RapidView rapidView, CardLayoutField cardLayoutField) {
        if (StringUtils.isBlank((CharSequence)cardLayoutField.getFieldId())) {
            return ServiceOutcomeImpl.error(CARD_LAYOUT_CONFIGURATION_CONTEXT, ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.cardlayout.error.no.field", new Object[0]);
        }
        ServiceOutcome<Boolean> maxReached = this.isMaxCardLayoutFieldsForModeLimitReached(rapidView, cardLayoutField.getMode());
        if (!maxReached.isValid()) {
            return ServiceOutcomeImpl.error(maxReached);
        }
        if (maxReached.getValue().booleanValue()) {
            return ServiceOutcomeImpl.error(CARD_LAYOUT_CONFIGURATION_CONTEXT, ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.cardlayout.table.add.maxreached", 3);
        }
        ServiceOutcome<Collection<String>> cardLayoutFieldIds = this.getConfiguredCardLayoutFieldIds(rapidView, cardLayoutField.getMode());
        if (!cardLayoutFieldIds.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFieldIds);
        }
        if (cardLayoutFieldIds.getValue().contains(cardLayoutField.getFieldId())) {
            return ServiceOutcomeImpl.error(CARD_LAYOUT_CONFIGURATION_CONTEXT, ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.cardlayout.error.field.exists", cardLayoutField.getFieldId());
        }
        ServiceOutcome<Set<Field>> availableCardLayoutFields = this.getAvailableCardLayoutFields(user, rapidView, cardLayoutField.getMode());
        if (!availableCardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(availableCardLayoutFields);
        }
        HashSet availableFieldIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)availableCardLayoutFields.getValue(), (Function)new Function<Field, String>(){

            public String apply(@Nullable Field field) {
                return field.getId();
            }
        }));
        if (!availableFieldIds.contains(cardLayoutField.getFieldId())) {
            return ServiceOutcomeImpl.error(CARD_LAYOUT_CONFIGURATION_CONTEXT, ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.cardlayout.error.field.not.valid", cardLayoutField.getFieldId());
        }
        return ServiceOutcomeImpl.ok();
    }

    private List<CardLayoutFieldConfig> toCardLayoutFieldConfigList(List<CardLayoutField> cardLayoutFieldList) {
        Iterable cardLayoutFieldConfigs = Iterables.transform(cardLayoutFieldList, (Function)new Function<CardLayoutField, CardLayoutFieldConfig>(){

            public CardLayoutFieldConfig apply(CardLayoutField cardLayoutField) {
                return CardLayoutFieldConfigurationServiceImpl.this.toCardLayoutFieldConfig(cardLayoutField);
            }
        });
        return Lists.newArrayList((Iterable)cardLayoutFieldConfigs);
    }

    private CardLayoutFieldConfig toCardLayoutFieldConfig(CardLayoutField cardLayoutField) {
        Field field = this.fieldManager.getField(cardLayoutField.getFieldId());
        if (field != null && this.fieldManager.isNavigableField(field)) {
            NavigableField navigableField = this.fieldManager.getNavigableField(cardLayoutField.getFieldId());
            return CardLayoutFieldConfig.forValidField(cardLayoutField, navigableField);
        }
        return CardLayoutFieldConfig.forInvalidField(cardLayoutField);
    }

    private boolean isFieldExcluded(NavigableField navigableField) {
        CustomField customField;
        CustomFieldType customFieldType;
        ImmutableSet excludedFieldIds;
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        setBuilder.add((Object[])new String[]{"issuekey", "summary"});
        if (this.flagCustomFieldProvider.doesDefaultFieldExist()) {
            setBuilder.add((Object)this.flagCustomFieldProvider.getOrCreateDefaultField().getId());
        }
        if ((excludedFieldIds = setBuilder.build()).contains(navigableField.getId())) {
            return true;
        }
        return navigableField instanceof CustomField && ((customFieldType = (customField = (CustomField)navigableField).getCustomFieldType()) instanceof EpicColorCFType || customFieldType instanceof EpicLabelCFType || customFieldType instanceof EpicStatusCFType || customFieldType instanceof RankCFType || customFieldType instanceof LexoRankCFType || customFieldType instanceof ReleasedVersionHistoryCFType);
    }
}

