/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.cardlayout;

import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.google.common.base.Function;
import com.google.common.base.Predicate;

public class CardLayoutFieldConfig {
    private final CardLayoutField cardLayoutField;
    private final boolean isValid;
    private final NavigableField jiraField;
    public static Predicate<CardLayoutFieldConfig> IS_VALID = new Predicate<CardLayoutFieldConfig>(){

        public boolean apply(CardLayoutFieldConfig config) {
            return config.isValid();
        }
    };
    public static Function<CardLayoutFieldConfig, NavigableField> TO_FIELD = new Function<CardLayoutFieldConfig, NavigableField>(){

        public NavigableField apply(CardLayoutFieldConfig config) {
            return config.getJiraField();
        }
    };

    private CardLayoutFieldConfig(CardLayoutField cardLayoutField, boolean valid, NavigableField jiraField) {
        this.cardLayoutField = cardLayoutField;
        this.isValid = valid;
        this.jiraField = jiraField;
    }

    public static CardLayoutFieldConfig forValidField(CardLayoutField cardLayoutField, NavigableField jiraField) {
        return new CardLayoutFieldConfig(cardLayoutField, true, jiraField);
    }

    public static CardLayoutFieldConfig forInvalidField(CardLayoutField cardLayoutField) {
        return new CardLayoutFieldConfig(cardLayoutField, false, null);
    }

    public CardLayoutField getCardLayoutField() {
        return this.cardLayoutField;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public NavigableField getJiraField() {
        return this.jiraField;
    }
}

