/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAO;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAOMapper;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneDao;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwimlaneServiceImpl
implements SwimlaneService {
    private static final int SWIMLANE_NAME_MAX_LENGTH = 255;
    private static final int SWIMLANE_DESCRIPTION_MAX_LENGTH = 255;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private SwimlaneDao swimlaneDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    @Autowired
    private SwimlaneAOMapper swimlaneAOMapper;
    private Cache<Long, ImmutableList<Swimlane>> swimlaneCache;

    @PostConstruct
    public void init() {
        this.swimlaneCache = this.cacheFactoryManager.create().getCache(SwimlaneServiceImpl.class.getName() + ".swimlaneCache", new SwimlaneCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public Set<SwimlaneStrategy> getValidStrategies() {
        return new HashSet<SwimlaneStrategy>(Arrays.asList(SwimlaneStrategy.values()));
    }

    @Override
    public List<Swimlane> loadSwimlanes(RapidView rapidView) {
        ImmutableList<Swimlane> swimlanes = this.swimlaneCache.get(rapidView.getId());
        return new ArrayList<Swimlane>((Collection<Swimlane>)swimlanes);
    }

    @Override
    public Swimlane get(ApplicationUser user, RapidView rapidView, long swimlaneId, ErrorCollection errors) {
        List<Swimlane> swimlanes = this.loadSwimlanes(rapidView);
        Swimlane swimlane = null;
        for (Swimlane potentialMatch : swimlanes) {
            if (potentialMatch.getId() != swimlaneId) continue;
            swimlane = potentialMatch;
            break;
        }
        if (swimlane == null) {
            errors.addError("gh.rapid.view.error.swimlane.id.invalid", swimlaneId);
            return null;
        }
        return swimlane;
    }

    @Override
    public ServiceOutcome<Swimlane> add(ApplicationUser user, RapidView rapidView, Swimlane swimlane) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        ErrorCollection errors = new ErrorCollection();
        this.validateSwimlane(user, swimlane, errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        List<Swimlane> swimlanes = this.loadSwimlanes(rapidView);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        swimlanes.add(0, swimlane);
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<SwimlaneAO> updatedSwimlaneAOs = this.swimlaneDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), swimlanes);
        this.swimlaneCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.swimlaneAOMapper.toModel(updatedSwimlaneAOs.get(0)));
    }

    @Override
    public Swimlane update(ApplicationUser user, RapidView rapidView, Swimlane swimlane, ErrorCollection errors) {
        Swimlane existingSwimlane = this.get(user, rapidView, swimlane.getId(), errors);
        if (existingSwimlane == null) {
            errors.addError("gh.rapid.view.error.swimlane.id.invalid", swimlane.getId());
            return null;
        }
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            errors.addAllErrors(validatedPermission.getErrors());
            return null;
        }
        this.validateSwimlane(user, swimlane, errors);
        if (errors.hasErrors()) {
            return null;
        }
        this.swimlaneDao.updateSwimlane(swimlane, errors);
        if (errors.hasErrors()) {
            return null;
        }
        this.swimlaneCache.remove(rapidView.getId());
        return this.get(user, rapidView, swimlane.getId(), errors);
    }

    @Override
    @Nonnull
    public ServiceOutcome<List<Swimlane>> replace(ApplicationUser user, RapidView rapidView, List<Swimlane> swimlanes) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        ErrorCollection errors = new ErrorCollection();
        for (Swimlane swimlane : swimlanes) {
            this.validateSwimlane(user, swimlane, errors);
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        boolean defaultFound = false;
        for (Swimlane swimlane : swimlanes) {
            if (!swimlane.isDefaultLane()) continue;
            defaultFound = true;
            if (swimlanes.get(swimlanes.size() - 1) == swimlane) continue;
            errors.addError("Default swimlane must be the last swimlane", new Object[0]);
            return ServiceOutcomeImpl.from(errors);
        }
        if (!defaultFound) {
            errors.addError("Default swimlane must be provided", new Object[0]);
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome serviceOutcome = this.rapidViewDao.load(rapidView.getId());
        if (!serviceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        List<SwimlaneAO> swimlaneAOs = this.swimlaneDao.updateForParent((RapidViewAO)serviceOutcome.getValue(), swimlanes);
        List swimlanesFromDb = this.swimlaneAOMapper.toModel(swimlaneAOs);
        this.swimlaneCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(swimlanesFromDb);
    }

    @Override
    public void delete(ApplicationUser user, RapidView rapidView, long swimlaneId, ErrorCollection errors) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            errors.addAllErrors(validatedPermission.getErrors());
            return;
        }
        Object swimlanes = this.swimlaneAOMapper.toModel(this.swimlaneDao.getForParent(rapidView.getId()));
        Swimlane existingSwimlane = this.findById((List<Swimlane>)swimlanes, swimlaneId);
        if (existingSwimlane == null) {
            errors.addError("gh.rapid.view.error.swimlane.id.invalid", swimlaneId);
            return;
        }
        if (existingSwimlane.isDefaultLane()) {
            errors.addError("gh.rapid.view.error.swimlane.default.not.deletable", new Object[0]);
            return;
        }
        swimlanes.remove(existingSwimlane);
        this.updateSwimlanes(rapidView, (List<Swimlane>)swimlanes);
        this.swimlaneCache.remove(rapidView.getId());
    }

    @Override
    public ServiceOutcome<Void> moveAfter(ApplicationUser user, RapidView rapidView, long swimlaneId, Long moveToSwimlaneId) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        Object swimlanes = this.swimlaneAOMapper.toModel(this.swimlaneDao.getForParent(rapidView.getId()));
        Swimlane swimlane = this.findById((List<Swimlane>)swimlanes, swimlaneId);
        if (swimlane == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.swimlane.id.invalid", swimlaneId);
        }
        Swimlane targetSwimlane = null;
        if (moveToSwimlaneId != null && (targetSwimlane = this.findById((List<Swimlane>)swimlanes, moveToSwimlaneId)) == null) {
            ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.swimlane.id.invalid", swimlaneId);
        }
        swimlanes.remove(swimlane);
        int insertIndex = targetSwimlane != null ? swimlanes.indexOf(targetSwimlane) + 1 : 0;
        swimlanes.add(insertIndex, (Swimlane)swimlane);
        this.forceDefaultSwimlaneLast((List<Swimlane>)swimlanes);
        this.updateSwimlanes(rapidView, (List<Swimlane>)swimlanes);
        this.swimlaneCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public void invalidate(RapidView rapidView) {
        this.swimlaneCache.remove(rapidView.getId());
    }

    private ServiceOutcome<Void> updateSwimlanes(RapidView rapidView, List<Swimlane> swimlanes) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        this.swimlaneDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), swimlanes);
        return ServiceOutcomeImpl.ok();
    }

    private void forceDefaultSwimlaneLast(List<Swimlane> swimlanes) {
        Swimlane defaultLane = null;
        Iterator<Swimlane> swimlaneIterator = swimlanes.iterator();
        while (swimlaneIterator.hasNext()) {
            Swimlane next = swimlaneIterator.next();
            if (!next.isDefaultLane() || !swimlaneIterator.hasNext()) continue;
            defaultLane = next;
        }
        if (defaultLane != null) {
            swimlanes.remove(defaultLane);
            swimlanes.add(defaultLane);
        }
    }

    private void validateSwimlane(ApplicationUser user, Swimlane swimlane, ErrorCollection errors) {
        this.validateName(swimlane, errors);
        this.validateQuery(user, swimlane.getQuery(), errors);
        this.validateDescription(swimlane, errors);
    }

    private void validateName(Swimlane swimlane, ErrorCollection errors) {
        if (StringUtils.isBlank((CharSequence)swimlane.getName())) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.rapid.view.error.name.required", new Object[0]);
        } else if (swimlane.getName().length() > 255) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.rapid.view.error.string.too.long", "Name", 255);
        }
    }

    private void validateQuery(ApplicationUser user, String query, ErrorCollection errors) {
        this.jqlHelper.validateJql(user, query, "query", errors);
    }

    private void validateDescription(Swimlane swimlane, ErrorCollection errors) {
        if (swimlane.getDescription() == null) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "description", "Description must not be null", new Object[0]);
        } else if (swimlane.getDescription().length() > 255) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "description", "gh.rapid.view.error.string.too.long", "Description", 255);
        }
    }

    private void validateDefaultLaneFlag(Swimlane swimlane, boolean expected, ErrorCollection errors) {
        if (swimlane.isDefaultLane() != expected) {
            errors.addContextualError("defaultLane", "You are not allowed to change a swimlane from default to non-default or the other way around", new Object[0]);
        }
    }

    private Swimlane findById(List<Swimlane> swimlanes, long swimlaneId) {
        for (Swimlane swimlane : swimlanes) {
            if (swimlane.getId() != swimlaneId) continue;
            return swimlane;
        }
        return null;
    }

    @Override
    public void flushCache() {
        this.swimlaneCache.removeAll();
    }

    private class SwimlaneCacheLoader
    implements CacheLoader<Long, ImmutableList<Swimlane>> {
        private SwimlaneCacheLoader() {
        }

        @Override
        public ImmutableList<Swimlane> load(@Nonnull Long rapidViewId) {
            SwimlaneAO[] swimlaneAOs = SwimlaneServiceImpl.this.swimlaneDao.getForParent(rapidViewId);
            Object swimlanesFromDb = SwimlaneServiceImpl.this.swimlaneAOMapper.toModel(swimlaneAOs);
            return ImmutableList.copyOf(swimlanesFromDb);
        }
    }
}

