/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAO;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAOListMapper;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAOMapper;
import java.util.List;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwimlaneDao
extends GenericActiveObjectsDao<Long, SwimlaneAO>
implements RelatedEntityDao<Long, RapidViewAO, SwimlaneAO, Swimlane> {
    @Autowired
    private SwimlaneAOMapper swimlaneAOMapper;

    public SwimlaneAO getSwimlane(long rapidViewId, long swimlaneId) {
        SwimlaneAO[] swimlane = (SwimlaneAO[])this.ao.find(SwimlaneAO.class, "RAPID_VIEW_ID = ? and ID = ?", new Object[]{rapidViewId, swimlaneId});
        return swimlane.length > 0 ? swimlane[0] : null;
    }

    public SwimlaneAO[] getForParent(RapidViewAO parent) {
        return this.getForParent(parent.getId());
    }

    public SwimlaneAO[] getForParent(Long rapidViewId) {
        return (SwimlaneAO[])this.ao.find(SwimlaneAO.class, "RAPID_VIEW_ID = ?", new Object[]{rapidViewId});
    }

    public SwimlaneAO updateSwimlane(Swimlane swimlane, ErrorCollection errors) {
        SwimlaneAO swimlaneAO = (SwimlaneAO)this.ao.get(SwimlaneAO.class, (Object)swimlane.getId());
        if (swimlaneAO == null) {
            errors.addError("gh.rapid.view.error.swimlane.id.invalid", swimlane.getId());
            return null;
        }
        this.swimlaneAOMapper.update(swimlane, swimlaneAO);
        swimlaneAO.save();
        return swimlaneAO;
    }

    @Override
    public List<SwimlaneAO> updateForParent(RapidViewAO rapidViewAO, List<Swimlane> swimlanes) {
        return AOUtil.setListValues(this.ao, new SwimlaneAOListMapper(rapidViewAO, this.swimlaneAOMapper), swimlanes);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        this.ao.delete((RawEntity[])rapidViewAO.getSwimlanes());
    }
}

