/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.AbstractAOMapper;
import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class SwimlaneAOMapper
extends AbstractAOMapper<SwimlaneAO, Swimlane>
implements RelatedAOMapper<RapidViewAO, SwimlaneAO, Swimlane> {
    @Override
    public Map<String, Object> toAO(RapidViewAO rapidViewAO, Swimlane swimlane) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(swimlane));
        map.put("RAPID_VIEW_ID", rapidViewAO);
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(Swimlane swimlane) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NAME", swimlane.getName());
        map.put("LONG_QUERY", swimlane.getQuery());
        map.put("DESCRIPTION", swimlane.getDescription());
        map.put("DEFAULT_LANE", swimlane.isDefaultLane());
        map.put("POS", swimlane.getPosition());
        return map;
    }

    @Override
    @Nonnull
    public Swimlane toModel(SwimlaneAO swimlaneAO) {
        String query = swimlaneAO.getLongQuery();
        if (query == null) {
            query = swimlaneAO.getQuery();
        }
        return Swimlane.builder().id(swimlaneAO.getId()).name(swimlaneAO.getName()).position(swimlaneAO.getPos()).query(query).defaultLane(swimlaneAO.isDefaultLane()).description(swimlaneAO.getDescription()).build();
    }

    @Override
    public void update(Swimlane source, SwimlaneAO target) {
        target.setDefaultLane(source.isDefaultLane());
        target.setDescription(source.getDescription());
        target.setName(source.getName());
        target.setLongQuery(source.getQuery());
        if (target.getQuery() != null) {
            target.setQuery(null);
        }
    }
}

