/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.issue.fields.status.IssueStatus;
import com.atlassian.greenhopper.issue.fields.status.IssueStatusCategory;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.field.IssueStatusService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDefaultColumnCreationStrategy;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class StatusCategoryMappingColumnCreationStrategy
implements RapidViewDefaultColumnCreationStrategy {
    @VisibleForTesting
    static final int TO_DO_CATEGORY = 2;
    @VisibleForTesting
    static final int IN_PROGRESS_CATEGORY = 4;
    @VisibleForTesting
    static final int DONE_CATEGORY = 3;
    private final WorkflowService workflowService;
    private final IssueStatusService issueStatusService;
    private final SavedFilterService savedFilterService;
    private final I18nFactoryService i18nFactoryService;
    private final FeatureManager featureManager;

    @Autowired
    StatusCategoryMappingColumnCreationStrategy(WorkflowService workflowService, IssueStatusService issueStatusService, SavedFilterService savedFilterService, I18nFactoryService i18nFactoryService, FeatureManager featureManager) {
        this.workflowService = workflowService;
        this.savedFilterService = savedFilterService;
        this.issueStatusService = issueStatusService;
        this.i18nFactoryService = i18nFactoryService;
        this.featureManager = featureManager;
    }

    @Override
    public List<Column> createDefaultColumns(ApplicationUser user, RapidView rapidView, @Nonnull RapidViewPreset rapidViewPreset) {
        Preconditions.checkArgument((rapidViewPreset.equals((Object)RapidViewPreset.KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SAMPLE_KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SCRUM) ? 1 : 0) != 0, (Object)("createDefaultColumns called with unsupported rapidViewPreset: " + (Object)((Object)rapidViewPreset)));
        Set<Status> accessibleStatuses = this.getAccessibleStatusesBasedOnRapidViewFilter(user, rapidView);
        List<Column> columns = this.mapStatusesToColumnsByStatusCategory(accessibleStatuses);
        if ((rapidViewPreset.equals((Object)RapidViewPreset.KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SAMPLE_KANBAN)) && this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            columns.add(0, KanbanBacklogColumn.emptyKanbanBacklogColumn());
        }
        return columns;
    }

    private List<Column> mapStatusesToColumnsByStatusCategory(Set<Status> accessibleStatuses) {
        Column.ColumnBuilder todoColumnBuilder = Column.builder().name("gh.boards.todo");
        Column.ColumnBuilder inProgressColumnBuilder = Column.builder().name("gh.boards.inprog");
        Column.ColumnBuilder doneColumnBuilder = Column.builder().name("gh.boards.done");
        block4: for (Status status : accessibleStatuses) {
            IssueStatus issueStatus = this.issueStatusService.getIssueStatus(status);
            switch (this.getIssueStatusCategoryId(issueStatus)) {
                case 4: {
                    inProgressColumnBuilder.statusId(status.getId());
                    continue block4;
                }
                case 3: {
                    doneColumnBuilder.statusId(status.getId());
                    continue block4;
                }
            }
            todoColumnBuilder.statusId(status.getId());
        }
        return Lists.newArrayList((Object[])new Column[]{todoColumnBuilder.build(), inProgressColumnBuilder.build(), doneColumnBuilder.build()});
    }

    private Set<Status> getAccessibleStatusesBasedOnRapidViewFilter(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<SearchRequest> savedFilterOutcome = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (savedFilterOutcome.isInvalid()) {
            ErrorCollections.checkErrors(savedFilterOutcome.getErrors(), this.i18nFactoryService.getI18n());
        }
        Query rapidViewQuery = savedFilterOutcome.getValue().getQuery();
        return this.workflowService.getAccessibleStatuses(user, rapidViewQuery);
    }

    private int getIssueStatusCategoryId(IssueStatus issueStatus) {
        Long statusCategoryIdLong;
        int issueStatusCategoryId = 2;
        IssueStatusCategory statusCategory = issueStatus.getStatusCategory();
        if (statusCategory != null && (statusCategoryIdLong = statusCategory.getId()) != null) {
            issueStatusCategoryId = statusCategoryIdLong.intValue();
        }
        return issueStatusCategoryId;
    }
}

