/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldInstance;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldAO;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldAOMapper;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldDao;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsFieldServiceImpl
implements StatisticsFieldService {
    public static final String ISSUE_COUNT_NAME_KEY = "gh.rapid.config.statistics.issuecount";
    public static final String ISSUE_COUNT_EXCL_SUBS_NAME_KEY = "gh.rapid.config.statistics.issuecount.excluding.subs";
    public static final String NONE_NAME_KEY = "gh.rapid.config.statistics.none";
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private StatisticsFieldDao statisticsFieldDao;
    @Autowired
    private StatisticsFieldAOMapper statisticsFieldAOMapper;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, StatisticsFieldConfig> statisticsFieldCache;

    @PostConstruct
    public void init() {
        this.statisticsFieldCache = this.cacheFactoryManager.create().getCache(StatisticsFieldServiceImpl.class.getName() + ".statisticsFieldCache", new StatisticsFieldCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public StatisticsFieldConfig updateStatisticsField(ApplicationUser user, ErrorCollection errors, RapidView rapidView, StatisticsFieldConfig statisticsField) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            errors.addAllErrors(validatedPermission.getErrors());
            return null;
        }
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            errors.addAllErrors(rapidViewAO.getErrors());
            return null;
        }
        StatisticsFieldAO statsFieldAO = this.statisticsFieldDao.updateStatisticsField((RapidViewAO)rapidViewAO.getValue(), statisticsField);
        StatisticsFieldConfig statisticsFieldConfig = this.fromAO(statsFieldAO);
        this.statisticsFieldCache.remove(rapidView.getId());
        return statisticsFieldConfig;
    }

    @Override
    @Nonnull
    public ServiceOutcome<StatisticsFieldConfig> loadStatisticsField(RapidView rapidView) {
        StatisticsFieldConfig statisticsFieldConfig = this.statisticsFieldCache.get(rapidView.getId());
        return ServiceOutcomeImpl.ok(statisticsFieldConfig);
    }

    @Override
    public ServiceOutcome<StatisticsFieldInstance> loadStatisticsFieldInstance(RapidView rapidView) {
        ServiceOutcome<StatisticsFieldConfig> config = this.loadStatisticsField(rapidView);
        if (!config.isValid()) {
            return ServiceOutcomeImpl.error(config);
        }
        ServiceOutcome<StatisticsFieldInstance> instance = this.getInstanceOfField(config.getValue());
        if (!instance.isValid()) {
            return ServiceOutcomeImpl.error(instance);
        }
        return ServiceOutcomeImpl.ok(instance.getValue());
    }

    private StatisticsFieldConfig fromAO(StatisticsFieldAO statFieldAO) {
        if (statFieldAO == null) {
            return this.getDefaultStatisticsFieldConfig();
        }
        return this.statisticsFieldAOMapper.toModel(statFieldAO);
    }

    @Override
    public StatisticsFieldConfig getDefaultStatisticsFieldConfig() {
        return new StatisticsFieldConfig.StatisticsFieldConfigBuilder().type(StatisticsFieldConfig.Type.NONE).build();
    }

    @Override
    public List<StatisticsFieldConfig> getAvailableStatisticsFieldConfigs() {
        ArrayList<StatisticsFieldConfig> statisticsFields = new ArrayList<StatisticsFieldConfig>();
        statisticsFields.add(StatisticsFieldConfig.buildNone());
        statisticsFields.add(StatisticsFieldConfig.buildIssueCount());
        statisticsFields.add(StatisticsFieldConfig.buildIssueCountExcludingSubs());
        return statisticsFields;
    }

    @Override
    public List<StatisticsFieldInstance> getAvailableStatisticsFields() {
        List<StatisticsFieldConfig> configs = this.getAvailableStatisticsFieldConfigs();
        ArrayList<StatisticsFieldInstance> instances = new ArrayList<StatisticsFieldInstance>();
        for (StatisticsFieldConfig config : configs) {
            instances.add(this.getInstanceOfField(config).getValue());
        }
        return instances;
    }

    @Override
    @Nonnull
    public ServiceOutcome<StatisticsFieldInstance> getInstanceOfField(StatisticsFieldConfig config) {
        if (config.getType() == StatisticsFieldConfig.Type.JIRA_FIELD) {
            ServiceOutcome<Field> result = this.getJiraField(config.getFieldId());
            if (result.isValid()) {
                return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forJiraField(config, result.getValue()));
            }
            return ServiceOutcomeImpl.error(result);
        }
        String nameKey = this.getNameKey(config.getType());
        return ServiceOutcomeImpl.ok(StatisticsFieldInstance.forNonField(config, nameKey));
    }

    @Override
    public void invalidate(RapidView rapidView) {
        this.statisticsFieldCache.remove(rapidView.getId());
    }

    private String getNameKey(StatisticsFieldConfig.Type type) {
        switch (type) {
            case ISSUE_COUNT: {
                return ISSUE_COUNT_NAME_KEY;
            }
            case ISSUE_COUNT_EXCL_SUBS: {
                return ISSUE_COUNT_EXCL_SUBS_NAME_KEY;
            }
            case NONE: {
                return NONE_NAME_KEY;
            }
        }
        return "";
    }

    private List<? extends Field> getValidFields() {
        return this.customFieldService.getCustomFields(NumberCFType.class, false);
    }

    private ServiceOutcome<Field> getJiraField(String fieldId) {
        CustomField field = this.customFieldService.getCustomField(fieldId);
        if (field == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.config.statistics.error.field.not.found", fieldId);
        }
        List<? extends Field> validFields = this.getValidFields();
        for (Field field2 : validFields) {
            if (!field2.getId().equals(field.getId())) continue;
            return ServiceOutcomeImpl.ok(field);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.statistics.error.field.not.found", fieldId);
    }

    @Override
    public void flushCache() {
        this.statisticsFieldCache.removeAll();
    }

    private class StatisticsFieldCacheLoader
    implements CacheLoader<Long, StatisticsFieldConfig> {
        private StatisticsFieldCacheLoader() {
        }

        @Override
        public StatisticsFieldConfig load(@Nonnull Long rapidViewId) {
            StatisticsFieldAO statFieldAO = StatisticsFieldServiceImpl.this.statisticsFieldDao.getStatisticsFieldForRapidView(rapidViewId);
            return StatisticsFieldServiceImpl.this.fromAO(statFieldAO);
        }
    }
}

