/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.ObjectNotFoundException;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldAO;
import net.java.ao.DBParam;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class StatisticsFieldDao
extends GenericActiveObjectsDao<Long, StatisticsFieldAO> {
    public StatisticsFieldAO getStatisticsField(long statisticsFieldId) {
        StatisticsFieldAO[] fields = (StatisticsFieldAO[])this.ao.find(StatisticsFieldAO.class, "ID = ?", new Object[]{statisticsFieldId});
        if (fields.length != 1) {
            throw new ObjectNotFoundException(statisticsFieldId, StatisticsFieldAO.class);
        }
        return fields[0];
    }

    public StatisticsFieldAO getStatisticsFieldForRapidView(long rapidViewId) {
        StatisticsFieldAO[] fields = (StatisticsFieldAO[])this.ao.find(StatisticsFieldAO.class, "RAPID_VIEW_ID = ?", new Object[]{rapidViewId});
        if (fields.length > 0) {
            if (fields.length > 1) {
                this.log.warn("More than one StatisticsFieldAO for foreign key RAPID_VIEW_ID %d found. Using first.", rapidViewId);
            }
            return fields[0];
        }
        this.log.error("No StatisticsFieldAO for foreign key RAPID_VIEW_ID %d found.", rapidViewId);
        return null;
    }

    public StatisticsFieldAO updateStatisticsField(RapidViewAO rapidViewAO, StatisticsFieldConfig statisticsField) {
        Validate.notNull((Object)rapidViewAO, (String)"RapidViewAO object must not be null when saving", (Object[])new Object[0]);
        Validate.notNull((Object)statisticsField, (String)"StatisticsFieldConfig must not be null", (Object[])new Object[0]);
        StatisticsFieldAO statFieldAO = rapidViewAO.getStatisticsField();
        if (statFieldAO == null) {
            statFieldAO = (StatisticsFieldAO)this.ao.create(StatisticsFieldAO.class, new DBParam[]{new DBParam("TYPE_ID", (Object)statisticsField.getType().getId()), new DBParam("RAPID_VIEW_ID", (Object)rapidViewAO)});
        } else {
            statFieldAO.setTypeId(statisticsField.getType().getId());
            statFieldAO.save();
        }
        return statFieldAO;
    }

    public void deleteStatisticsField(RapidViewAO rapidViewAO) {
        StatisticsFieldAO statisticsFieldAO = rapidViewAO.getStatisticsField();
        if (statisticsFieldAO != null) {
            this.delete(new StatisticsFieldAO[]{statisticsFieldAO});
        }
    }
}

