/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.RapidViewIssue;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewVersionService;
import com.atlassian.greenhopper.service.rapid.view.VersionQuery;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidViewVersionServiceImpl
implements RapidViewVersionService {
    @Autowired
    private QueryService queryService;
    @Autowired
    private VersionManager versionManager;
    @Autowired
    private RapidViewIssueService rapidViewIssueService;

    @Override
    @Nonnull
    public ServiceOutcome<Page<Version>> getVersionsForRapidView(@Nullable ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull PageRequest pageRequest, @Nonnull VersionQuery query) {
        ServiceOutcome<Iterable<Version>> versionsForRapidView = this.getVersionsForRapidView(user, rapidView);
        if (!versionsForRapidView.isValid()) {
            return ServiceOutcomeImpl.error(versionsForRapidView);
        }
        Iterable<Version> filteredVersions = this.getFilteredVersions(versionsForRapidView.get(), query);
        return ServiceOutcomeImpl.ok(Pages.toPage(filteredVersions, pageRequest, null));
    }

    private ServiceOutcome<Iterable<Version>> getVersionsForRapidView(@Nullable ApplicationUser user, @Nonnull RapidView rapidView) {
        ServiceOutcome<Set<Project>> projectsForRapidView = this.getProjectsForRapidView(user, rapidView);
        if (!projectsForRapidView.isValid()) {
            return ServiceOutcomeImpl.error(projectsForRapidView);
        }
        return ServiceOutcomeImpl.ok(this.loadVersionDataForProjects(projectsForRapidView.get()));
    }

    private Iterable<Version> getFilteredVersions(Iterable<Version> allVersions, final VersionQuery query) {
        if (query.isReleased() == null) {
            return allVersions;
        }
        return Iterables.filter(allVersions, (Predicate)new Predicate<Version>(){

            public boolean apply(Version input) {
                return input.isReleased() == query.isReleased().booleanValue();
            }
        });
    }

    private Iterable<Version> loadVersionDataForProjects(Set<Project> projects) {
        ArrayList sortedProjects = Lists.newArrayList(projects);
        Collections.sort(sortedProjects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return Iterables.concat((Iterable)Iterables.transform((Iterable)sortedProjects, (Function)new Function<Project, Iterable<Version>>(){

            public Iterable<Version> apply(Project project) {
                return RapidViewVersionServiceImpl.this.versionManager.getVersions(project.getId(), false);
            }
        }));
    }

    private ServiceOutcome<Set<Project>> getProjectsForRapidView(@Nullable ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Set<Project>> projectsFromJql = this.queryService.getProjectsForRapidViewFilterQuery(user, rapidView);
        if (!projectsFromJql.isValid()) {
            return ServiceOutcomeImpl.error(projectsFromJql);
        }
        if (!projectsFromJql.get().isEmpty()) {
            return projectsFromJql;
        }
        ServiceOutcome<Page<RapidViewIssue>> issuesForRapidView = this.rapidViewIssueService.getIssuesForRapidView(user, rapidView, PageRequests.all(), null);
        if (!issuesForRapidView.isValid()) {
            return ServiceOutcomeImpl.error(issuesForRapidView);
        }
        ImmutableSet projectsFromIssues = ImmutableSet.copyOf((Iterable)Iterables.transform(issuesForRapidView.get().getValues(), (Function)new Function<RapidViewIssue, Project>(){

            public Project apply(RapidViewIssue input) {
                return input.getIssue().getProjectObject();
            }
        }));
        return ServiceOutcomeImpl.ok(projectsFromIssues);
    }
}

