/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewSprintQueryServiceImpl
implements RapidViewSprintQueryService {
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private SprintManager sprintManager;

    @Override
    public ServiceOutcome<List<Sprint>> getSprints(ApplicationUser user, RapidView rapidView, EnumSet<Sprint.State> states, boolean includeHistoricSprints) {
        ServiceOutcome<Query> rapidViewQueryOutcome = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (rapidViewQueryOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewQueryOutcome);
        }
        ServiceOutcome<List<Sprint>> sprintsByQuery = this.sprintQueryService.getSprints(user, rapidViewQueryOutcome.getValue(), includeHistoricSprints);
        if (sprintsByQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintsByQuery);
        }
        ServiceOutcome<Collection<Sprint>> sprintsOwnedByBoard = this.sprintManager.getSprintsForView(rapidView);
        if (sprintsOwnedByBoard.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintsOwnedByBoard);
        }
        return ServiceOutcomeImpl.ok(SprintUtils.getFilteredAndSortedSprints(SprintUtils.SPRINT_NATURAL_COMPARATOR, states, sprintsByQuery.getValue(), sprintsOwnedByBoard.getValue()));
    }
}

