/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.RapidViewNameComparator;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewQuery;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSimpleQuery;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class RapidViewServiceImpl
implements RapidViewService {
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RapidViewManager rapidViewManager;
    @Autowired
    private ProjectRapidViewService projectRapidViewService;

    @Override
    @Nonnull
    public ServiceOutcome<RapidView> create(@Nullable ApplicationUser user, String name, Long savedFilterId, RapidViewPreset preset) {
        Validate.notNull((Object)user, (String)"ApplicationUser must not be null when creating a RapidView", (Object[])new Object[0]);
        ErrorCollection errors = new ErrorCollection();
        this.validateFilterId(savedFilterId, errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome<SearchRequest> savedFilter = this.getOrCopyFilterForCreate(user, name, savedFilterId);
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        return this.rapidViewManager.create(user, name, savedFilter.get().getId(), preset);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RapidView> copy(@Nullable ApplicationUser user, RapidView sourceRapidView) {
        Validate.notNull((Object)user, (String)"ApplicationUser must not be null when copying a RapidView", (Object[])new Object[0]);
        Validate.notNull((Object)sourceRapidView, (String)"sourceRapidView must not be null when copying a RapidView", (Object[])new Object[0]);
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        String newBoardName = i18n.getText("gh.rapid.view.copy.name.format", (Object)sourceRapidView.getName());
        ServiceOutcome<SearchRequest> savedFilter = this.getOrCopyFilterForCreate(user, newBoardName, sourceRapidView.getSavedFilterId());
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        String userKey = ApplicationUsers.getKeyFor((ApplicationUser)user);
        RapidView.RapidViewBuilder rapidBoardBuild = RapidView.builder(sourceRapidView).name(newBoardName).owner(userKey);
        if (savedFilter.getValue() != null) {
            rapidBoardBuild.savedFilterId(savedFilter.get().getId());
        }
        RapidView destinationRapidView = rapidBoardBuild.build();
        return this.rapidViewManager.copy(sourceRapidView, destinationRapidView, user);
    }

    private ServiceOutcome<SearchRequest> getOrCopyFilterForCreate(@Nullable ApplicationUser user, String newBoardName, Long savedFilterId) {
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, savedFilterId);
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateCreatePermission(user, savedFilter.get());
        if (validatedPermission.isValid()) {
            return savedFilter;
        }
        return this.savedFilterService.createSavedFilter(user, newBoardName, savedFilter.get().getQuery(), SharedEntity.SharePermissions.PRIVATE);
    }

    @Override
    @Nonnull
    public ServiceResult update(@Nullable ApplicationUser user, RapidView rapidView) {
        Validate.notNull((Object)rapidView, (String)"RapidView must not be null when updating", (Object[])new Object[0]);
        Validate.notNull((Object)rapidView.getId(), (String)"RapidView ID must not be null when updating", (Object[])new Object[0]);
        Validate.notNull((Object)user, (String)"ApplicationUser must not be null when updating a RapidView", (Object[])new Object[0]);
        ServiceOutcome<RapidView> currentView = this.getRapidView(user, rapidView.getId());
        if (!currentView.isValid()) {
            return currentView;
        }
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (!savedFilter.isValid()) {
            return savedFilter;
        }
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, currentView.get());
        if (!validatedPermission.isValid()) {
            return validatedPermission;
        }
        return this.rapidViewManager.update(rapidView);
    }

    @Override
    @Nonnull
    public ServiceResult delete(@Nullable ApplicationUser user, RapidView rapidView) {
        Validate.notNull((Object)rapidView, (String)"RapidView must not be null when deleting a RapidView", (Object[])new Object[0]);
        Validate.notNull((Object)user, (String)"ApplicationUser must not be null when deleting a RapidView", (Object[])new Object[0]);
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return validatedPermission;
        }
        return this.rapidViewManager.delete(rapidView);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RapidView> getFirstVisibleRapidView(final @Nullable ApplicationUser user) {
        return this.rapidViewManager.getFirst(new RapidViewManager.RapidViewPermissionCheck(){

            @Override
            public boolean check(RapidView view) {
                return RapidViewServiceImpl.this.rapidViewPermissionService.canSeeRapidView(user, view);
            }
        });
    }

    @Override
    @Nonnull
    public ServiceOutcome<List<RapidView>> getRapidViews(final @Nullable ApplicationUser user) {
        return this.rapidViewManager.getAll(new RapidViewManager.RapidViewPermissionCheck(){

            @Override
            public boolean check(RapidView view) {
                return RapidViewServiceImpl.this.rapidViewPermissionService.canSeeRapidView(user, view);
            }
        });
    }

    @Override
    @Nonnull
    public ServiceOutcome<Page<RapidView>> getRapidViews(@Nullable ApplicationUser user, PageRequest pageRequest, RapidViewQuery query) {
        ServiceOutcome<Iterable<RapidView>> rapidViewsOutcome = this.rapidViewManager.find(RapidViewSimpleQuery.fromRapidViewQuery(query));
        if (!rapidViewsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewsOutcome);
        }
        Iterable<RapidView> filteredRapidViews = this.filterRapidViews(rapidViewsOutcome.get(), user, query);
        List sortedRapidViews = Ordering.from((Comparator)RapidViewNameComparator.INSTANCE).sortedCopy(filteredRapidViews);
        return ServiceOutcomeImpl.ok(Pages.toPage(sortedRapidViews, pageRequest, Long.valueOf(sortedRapidViews.size())));
    }

    @Override
    @Nonnull
    public ServiceOutcome<RapidView> getRapidView(@Nullable ApplicationUser user, @Nullable Long rapidViewId) {
        if (rapidViewId == null) {
            return ServiceOutcomeImpl.error("rapidViewId", ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.noview", new Object[0]);
        }
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewManager.get(rapidViewId);
        if (!rapidViewOutcome.isValid() || this.rapidViewPermissionService.canSeeRapidView(user, rapidViewOutcome.get())) {
            return rapidViewOutcome;
        }
        return ServiceOutcomeImpl.error("rapidViewId", ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.noview", new Object[0]);
    }

    private Iterable<RapidView> filterRapidViews(Iterable<RapidView> rapidViews, @Nullable ApplicationUser user, RapidViewQuery query) {
        Iterable visibleRapidViews = Iterables.filter(rapidViews, this.userSeesRapidView(user));
        if (query.getProject() == null) {
            return visibleRapidViews;
        }
        return Iterables.filter((Iterable)visibleRapidViews, this.boardBelongsToProject(user, query.getProject()));
    }

    private Predicate<RapidView> userSeesRapidView(@Nullable ApplicationUser user) {
        return rapidView -> this.rapidViewPermissionService.canSeeRapidView(user, (RapidView)rapidView);
    }

    private Predicate<RapidView> boardBelongsToProject(@Nullable ApplicationUser user, Project project) {
        return rapidView -> {
            ServiceOutcome<Set<Project>> projectsByRapidView = this.projectRapidViewService.findProjectsByRapidView(user, (RapidView)rapidView);
            if (projectsByRapidView.isInvalid()) {
                return false;
            }
            return projectsByRapidView.get().contains(project);
        };
    }

    private void validateFilterId(@Nullable Long savedFilterId, ErrorCollection errors) {
        if (savedFilterId == null) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "filterId", "gh.rapid.view.error.filter.id", new Object[0]);
        }
    }
}

