/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.util.OrderedPriorityHelper;
import com.atlassian.greenhopper.manager.issue.fields.StoryPointsCustomFieldProvider;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDefaultColumnCreationStrategy;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.service.workflow.PredefinedStatuses;
import com.atlassian.greenhopper.service.workflow.PresetData;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowPresets;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Strings;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewPresetService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String DEFAULT_SWIMLANE_NAME = "gh.rapid.swimlane.default.name";
    private static final String EXPEDITE_SWIMLANE_NAME = "gh.rapid.swimlane.expedite.name";
    private static final String EXPEDITE_SWIMLANE_DESC = "gh.rapid.swimlane.expedite.desc";
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private StoryPointsCustomFieldProvider storyPointsCustomFieldProvider;
    @Autowired
    private SimplifiedWorkflowService simplifiedWorkflowService;
    @Autowired
    private WorkingDaysService workingDaysService;
    @Autowired
    private RapidViewDefaultColumnCreationStrategy rapidViewDefaultColumnCreationStrategy;
    @Autowired
    private OrderedPriorityHelper orderedPriorityHelper;
    @Autowired
    private JqlStringSupport jqlStringSupport;
    @Autowired
    private FeatureManager featureManager;

    public Query createDefaultBaseQuery(RapidViewPreset preset, List<Project> projects) {
        JqlQueryBuilder query = JqlQueryBuilder.newBuilder();
        if (projects.size() > 1) {
            CollectionBuilder keyBuilder = CollectionBuilder.newBuilder();
            for (Project project : projects) {
                keyBuilder.add((Object)project.getKey());
            }
            query.where().project().in().strings((Collection)keyBuilder.asList());
        } else {
            query.where().project(new String[]{projects.get(0).getKey()});
        }
        CustomField rankField = this.rankCustomFieldService.getDefaultRankField();
        if (this.customFieldService.isUniqueFieldName(rankField)) {
            query.orderBy().addSortForFieldName(rankField.getName(), SortOrder.ASC, true);
        } else {
            String fieldName = new JqlCustomFieldId(rankField.getIdAsLong().longValue()).getJqlName();
            query.orderBy().add(fieldName, SortOrder.ASC, true);
        }
        return query.buildQuery();
    }

    public StatisticsFieldConfig createDefaultStatisticsField(@Nonnull RapidViewPreset rapidViewPreset) {
        if (rapidViewPreset.equals((Object)RapidViewPreset.SCRUM)) {
            return new StatisticsFieldConfig.StatisticsFieldConfigBuilder().type(StatisticsFieldConfig.Type.NONE).build();
        }
        if (rapidViewPreset.equals((Object)RapidViewPreset.KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SAMPLE_KANBAN)) {
            return new StatisticsFieldConfig.StatisticsFieldConfigBuilder().type(StatisticsFieldConfig.Type.ISSUE_COUNT).build();
        }
        throw new UnsupportedOperationException("createDefaultStatisticsField called with unsupported rapidViewPreset " + (Object)((Object)rapidViewPreset));
    }

    public List<Column> createDefaultColumns(ApplicationUser user, RapidView rapidView, @Nonnull RapidViewPreset rapidViewPreset) {
        return this.rapidViewDefaultColumnCreationStrategy.createDefaultColumns(user, rapidView, rapidViewPreset);
    }

    private List<Pair<Status, PredefinedStatuses>> getStatusList(List<PredefinedStatuses> statusEnums) {
        LinkedList<Pair<Status, PredefinedStatuses>> statuses = new LinkedList<Pair<Status, PredefinedStatuses>>();
        for (PredefinedStatuses statusEnum : statusEnums) {
            Status s = this.workflowService.getStatusByName(statusEnum.name);
            if (s != null) {
                statuses.add((Pair<Status, PredefinedStatuses>)Pair.of((Object)s, (Object)((Object)statusEnum)));
                continue;
            }
            this.log.warn("Expected status of '%s' to exist but it did not.", statusEnum.name);
        }
        return statuses;
    }

    public List<Swimlane> createDefaultSwimlanes(RapidViewPreset rapidViewPreset) {
        if (rapidViewPreset.equals((Object)RapidViewPreset.KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SAMPLE_KANBAN)) {
            ArrayList<Swimlane> lanes = new ArrayList<Swimlane>();
            this.createExpediteSwimlane(lanes);
            lanes.add(Swimlane.builder().name(DEFAULT_SWIMLANE_NAME).query("").description("").defaultLane(true).build());
            return lanes;
        }
        if (rapidViewPreset.equals((Object)RapidViewPreset.SCRUM)) {
            ArrayList<Swimlane> lanes = new ArrayList<Swimlane>();
            lanes.add(Swimlane.builder().name(DEFAULT_SWIMLANE_NAME).query("").description("").defaultLane(true).build());
            return lanes;
        }
        throw new UnsupportedOperationException("createDefaultSwimlanes called with unsupported rapidViewPreset " + (Object)((Object)rapidViewPreset));
    }

    private void createExpediteSwimlane(List<Swimlane> lanes) {
        Option<Priority> getPriority = this.orderedPriorityHelper.getHighestPriority();
        if (getPriority.isDefined() && !Strings.isNullOrEmpty((String)((Priority)getPriority.get()).getName())) {
            Query expediteQuery = JqlQueryBuilder.newClauseBuilder().priority(new String[]{((Priority)getPriority.get()).getName()}).buildQuery();
            lanes.add(Swimlane.builder().query(this.jqlStringSupport.generateJqlString(expediteQuery)).name(EXPEDITE_SWIMLANE_NAME).description(EXPEDITE_SWIMLANE_DESC).build());
        }
    }

    public List<QuickFilter> createDefaultQuickFilters(@Nonnull RapidViewPreset rapidViewPreset) {
        if (rapidViewPreset.equals((Object)RapidViewPreset.SCRUM) || rapidViewPreset.equals((Object)RapidViewPreset.KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SAMPLE_KANBAN)) {
            ArrayList<QuickFilter> filters = new ArrayList<QuickFilter>();
            QuickFilter onlyMyIssuesFilter = QuickFilter.builder().name("gh.rapid.quickfilters.only.my.issues").query("assignee = currentUser()").description("gh.rapid.quickfilters.only.my.issues.desc").build();
            filters.add(onlyMyIssuesFilter);
            QuickFilter recentlyUpdatedFilter = QuickFilter.builder().name("gh.rapid.quickfilters.recently.updated").query("updatedDate >= -1d").description("gh.rapid.quickfilters.recently.updated.desc").build();
            filters.add(recentlyUpdatedFilter);
            return filters;
        }
        throw new UnsupportedOperationException("createDefaultQuickFilters called with unsupported rapidViewPreset " + (Object)((Object)rapidViewPreset));
    }

    public boolean isSprintSupportEnabled(RapidViewPreset rapidViewPreset) {
        return rapidViewPreset.equals((Object)RapidViewPreset.SCRUM);
    }

    public List<Subquery> createDefaultSubqueries(@Nonnull RapidViewPreset rapidViewPreset) {
        if (rapidViewPreset.equals((Object)RapidViewPreset.KANBAN) || rapidViewPreset.equals((Object)RapidViewPreset.SAMPLE_KANBAN)) {
            return this.createKanbanDefaultSubqueries();
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<Subquery> createKanbanDefaultSubqueries() {
        ArrayList<Subquery> subqueries = new ArrayList<Subquery>();
        String workQuery = this.searchService.getGeneratedJqlString(JqlQueryBuilder.newBuilder().where().fixVersion().in().functionUnreleasedVersions(new String[0]).or().fixVersion().isEmpty().buildQuery());
        subqueries.add(Subquery.builder().query(workQuery).build());
        return subqueries;
    }

    @Nonnull
    public StatisticsFieldConfig createDefaultEstimationStatisticConfig(@Nonnull RapidViewPreset rapidViewPreset) {
        StatisticsFieldConfig estimateStatistic = RapidViewPreset.SCRUM == rapidViewPreset ? StatisticsFieldConfig.builder().type(StatisticsFieldConfig.Type.JIRA_FIELD).fieldId(this.storyPointsCustomFieldProvider.getOrCreateDefaultField().getId()).build() : StatisticsFieldConfig.builder().type(StatisticsFieldConfig.Type.NONE).build();
        return estimateStatistic;
    }

    @Nonnull
    public StatisticsFieldConfig createDefaultTrackingStatisticConfig(@Nonnull RapidViewPreset rapidViewPreset) {
        StatisticsFieldConfig trackingStatistic = StatisticsFieldConfig.builder().type(StatisticsFieldConfig.Type.NONE).build();
        return trackingStatistic;
    }

    @Nonnull
    public SwimlaneStrategy getDefaultSwimlaneStrategy(@Nonnull RapidViewPreset rapidViewPreset) {
        if (RapidViewPreset.SCRUM == rapidViewPreset) {
            return SwimlaneStrategy.PARENT_CHILD;
        }
        return SwimlaneStrategy.CUSTOM;
    }

    @Nonnull
    public CardColorStrategy getDefaultCardColorStrategy(RapidViewPreset preset) {
        return CardColorStrategy.NONE;
    }

    public boolean getDefaultShowDaysInColumnConfig(RapidViewPreset preset) {
        return false;
    }

    public RapidView.OldDoneIssuesCutoff getDefaultOldDoneIssuesCutoff(RapidViewPreset preset) {
        switch (preset) {
            case KANBAN: 
            case SAMPLE_KANBAN: {
                return RapidView.OldDoneIssuesCutoff.TWO_WEEKS;
            }
            case SCRUM: {
                return RapidView.OldDoneIssuesCutoff.NONE;
            }
        }
        throw new IllegalArgumentException("Unsupported preset: " + (Object)((Object)preset));
    }

    public List<Column> createColumnsForSimplifiedWorkflow(RapidViewPreset preset) {
        SimplifiedWorkflowPresets simplifiedWorkflowPreset;
        switch (preset) {
            case KANBAN: {
                simplifiedWorkflowPreset = SimplifiedWorkflowPresets.KANBAN_SIMPLIFIED_WORKFLOW;
                break;
            }
            case SCRUM: {
                simplifiedWorkflowPreset = SimplifiedWorkflowPresets.SIMPLIFIED_WORKFLOW;
                break;
            }
            case SAMPLE_KANBAN: {
                simplifiedWorkflowPreset = SimplifiedWorkflowPresets.KANBAN_SIMPLIFIED_SAMPLE_WORKFLOW;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rapid view preset " + (Object)((Object)preset));
            }
        }
        return this.createColumnsFromPresets(preset, simplifiedWorkflowPreset);
    }

    private List<Column> createColumnsFromPresets(RapidViewPreset preset, SimplifiedWorkflowPresets simplifiedWorkflowPreset) {
        LinkedList<Column> columns = new LinkedList<Column>();
        PresetData presetData = this.simplifiedWorkflowService.getPresetDefinitions().get((Object)simplifiedWorkflowPreset);
        List<PredefinedStatuses> statusEnums = presetData.getStatusNames();
        List<Pair<Status, PredefinedStatuses>> statuses = this.getStatusList(statusEnums);
        for (Pair<Status, PredefinedStatuses> status : statuses) {
            Column.ColumnBuilder column = Column.builder().name(((PredefinedStatuses)((Object)status.second())).i18nNameKey).statusId(((Status)status.first()).getId());
            for (List constraint : presetData.getColumnConstraintPreset().constraints) {
                Pair constraintValues = (Pair)constraint.get(statuses.indexOf(status));
                for (Double min : (Option)constraintValues.first()) {
                    column.min(min);
                }
                for (Double max : (Option)constraintValues.second()) {
                    column.max(max);
                }
            }
            columns.add(column.build());
        }
        if ((preset.equals((Object)RapidViewPreset.KANBAN) || preset.equals((Object)RapidViewPreset.SAMPLE_KANBAN)) && this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            columns.add(0, KanbanBacklogColumn.emptyKanbanBacklogColumn());
        }
        return columns;
    }

    @Nonnull
    public WorkingDaysConfig createDefaultWorkingDaysConfig(ApplicationUser user, @Nonnull RapidViewPreset rapidViewPreset) {
        String timezoneId = this.workingDaysService.getDateTimeZoneIdForUser(user);
        return WorkingDaysConfig.builder().monday(true).tuesday(true).wednesday(true).thursday(true).friday(true).saturday(false).sunday(false).timezoneId(timezoneId).build();
    }

    public static ProjectType getAssociatedProjectType(RapidViewPreset rapidViewPreset) {
        switch (rapidViewPreset) {
            case KANBAN: 
            case SAMPLE_KANBAN: {
                return ProjectType.KANBAN;
            }
            case SCRUM: {
                return ProjectType.SCRUM;
            }
        }
        throw new IllegalArgumentException("Invalid rapid view preset " + (Object)((Object)rapidViewPreset));
    }
}

