/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.util.UserUtils;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewPermissionServiceImpl
implements RapidViewPermissionService {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private BoardAdminService boardAdminService;
    @Autowired
    private ShareManager shareManager;
    @Autowired
    private SearchRequestManager searchRequestManager;

    @Override
    public boolean canSeeRapidView(ApplicationUser user, RapidView rapidView) {
        SearchRequest searchRequest = this.searchRequestManager.getSearchRequestById(rapidView.getSavedFilterId());
        return searchRequest != null && this.shareManager.isSharedWith(user, (SharedEntity)searchRequest);
    }

    @Override
    public boolean canCreate(ApplicationUser user, SearchRequest filter) {
        Validate.notNull((Object)filter, (String)"RapidView must not be null", (Object[])new Object[0]);
        return user != null && (filter.getPermissions().isPrivate() && UserUtils.isOwner(user, filter) || this.canCreate(user));
    }

    @Override
    public boolean canCreate(ApplicationUser user) {
        return user != null && this.permissionService.hasGlobalPermission(user, 22);
    }

    @Override
    public boolean canEdit(ApplicationUser user, RapidView rapidView) {
        Validate.notNull((Object)rapidView, (String)"RapidView must not be null", (Object[])new Object[0]);
        return user != null && (this.boardAdminService.isUserBoardAdmin(rapidView, user) || this.permissionService.isJiraAdministrator(user));
    }

    @Override
    public ServiceOutcome<Void> validateCreatePermission(ApplicationUser user, SearchRequest filter) {
        if (!this.canCreate(user, filter)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.view.create.error.not_permitted", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> validateModifyPermission(ApplicationUser user, RapidView view) {
        if (!this.canEdit(user, view)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.view.error.not_permitted", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public boolean isAdmin(ApplicationUser user, RapidView rapidView) {
        Validate.notNull((Object)rapidView, (String)"RapidView must not be null", (Object[])new Object[0]);
        return this.permissionService.isJiraAdministrator(user);
    }
}

