/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAOMapper;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSimpleQuery;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.java.ao.Query;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewDao
extends GenericActiveObjectsDao<Long, RapidViewAO> {
    @Autowired
    private RapidViewAOMapper rapidViewAOMapper;

    public void loadAll(Consumer<RapidViewAO> consumer) {
        this.ao.stream(RapidViewAO.class, consumer::accept);
    }

    public List<RapidViewAO> find(RapidViewSimpleQuery rapidViewQuery) {
        Query query = Query.select();
        Set<RapidView.Type> types = rapidViewQuery.getTypes();
        if (types.size() == 0) {
            return Collections.emptyList();
        }
        if (types.size() == 1) {
            boolean sprintsEnabled = types.contains((Object)RapidView.Type.SCRUM);
            query.where("SPRINTS_ENABLED = ?", new Object[]{sprintsEnabled});
        }
        Object[] rapidViewAOsArray = (RapidViewAO[])this.ao.find(RapidViewAO.class, query);
        if (rapidViewQuery.getPartialName() == null) {
            return ImmutableList.copyOf((Object[])rapidViewAOsArray);
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])rapidViewAOsArray), rapidViewAO -> {
            String query1 = rapidViewQuery.getPartialName().toLowerCase();
            return rapidViewAO.getName().toLowerCase().contains(query1);
        }));
    }

    public ServiceOutcome<RapidViewAO> update(RapidView rapidView) {
        Validate.notNull((Object)rapidView, (String)"RapidView object must not be null when updating", (Object[])new Object[0]);
        Validate.notNull((Object)rapidView.getId(), (String)"RapidView object must have an id when updating", (Object[])new Object[0]);
        Validate.notNull((Object)rapidView.getSavedFilterId(), (String)"RapidView object must have a saved filter ID", (Object[])new Object[0]);
        Validate.notNull((Object)rapidView.getOwner(), (String)"RapidView object must have an owner", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)rapidView.getSwimlaneStrategy()), (String)"RapidView object must have a swimlane strategy", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)rapidView.getCardColorStrategy()), (String)"RapidView object must have a card color strategy", (Object[])new Object[0]);
        ServiceOutcome outcome = this.load(rapidView.getId());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        RapidViewAO rapidViewAO = (RapidViewAO)outcome.getValue();
        this.rapidViewAOMapper.update(rapidView, rapidViewAO);
        rapidViewAO.save();
        return ServiceOutcomeImpl.ok(rapidViewAO);
    }

    public int count() {
        return this.ao.count(RapidViewAO.class);
    }

    public List<RapidViewAO> findByFilterId(long filterId) {
        Query query = Query.select().where("SAVED_FILTER_ID = ?", new Object[]{filterId});
        Object[] rapidViewAOs = (RapidViewAO[])this.ao.find(RapidViewAO.class, query);
        return Lists.newArrayList((Object[])rapidViewAOs);
    }
}

