/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.model.rapid.ColumnConfig;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewConfigManagerImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewConfigService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RapidViewConfigServiceImpl
implements RapidViewConfigService {
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private StatusService statusService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RapidViewConfigManagerImpl rapidViewConfigManager;

    @Override
    public ColumnConfig getColumnConfig(@Nullable ApplicationUser user, @Nonnull RapidView rapidView) {
        return this.rapidViewConfigManager.getColumnConfig(rapidView, (Function<String, Status>)((Function)statusId -> this.statusService.getStatusById(user, statusId)), this.i18nFactoryService.getI18n(user));
    }

    @Override
    @Nullable
    public EstimationConfig getEstimationConfig(@Nullable ApplicationUser user, @Nonnull RapidView rapidView) {
        return this.rapidViewConfigManager.getEstimationConfig(rapidView);
    }

    @Override
    @Nullable
    public Long getRankFieldId(@Nullable ApplicationUser user, @Nonnull RapidView rapidView) {
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (savedFilter.isInvalid()) {
            return null;
        }
        ServiceOutcome<CustomField> rankCustomField = this.lexoRankCustomFieldService.getValidatedCustomFieldSortedByRankField(user, savedFilter.get().getQuery());
        if (rankCustomField.isInvalid()) {
            return null;
        }
        return rankCustomField.get().getIdAsLong();
    }
}

