/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.api.rapid.view.Column;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.ColumnConfig;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.SortedByRankFieldResult;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewConfigManager;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.status.Status;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RapidViewConfigManagerImpl
implements RapidViewConfigManager {
    @Autowired
    private SearchRequestManager searchRequestManager;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;
    @Autowired
    private StatusManager statusManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    private static final Map<StatisticsFieldConfig.Type, EstimationConfig.Type> statisticsConfigTypeToEstimationConfigType = ImmutableBiMap.builder().put((Object)StatisticsFieldConfig.Type.NONE, (Object)EstimationConfig.Type.NONE).put((Object)StatisticsFieldConfig.Type.ISSUE_COUNT, (Object)EstimationConfig.Type.ISSUE_COUNT).put((Object)StatisticsFieldConfig.Type.ISSUE_COUNT_EXCL_SUBS, (Object)EstimationConfig.Type.ISSUE_COUNT_EXCL_SUBS).put((Object)StatisticsFieldConfig.Type.JIRA_FIELD, (Object)EstimationConfig.Type.JIRA_FIELD).build();

    @Override
    @Nullable
    public Long getRankFieldId(@Nonnull RapidView rapidView) {
        SearchRequest savedFilter = this.searchRequestManager.getSearchRequestById(rapidView.getSavedFilterId());
        if (savedFilter == null) {
            return null;
        }
        ServiceOutcome<SortedByRankFieldResult> sortedByRankField = this.lexoRankCustomFieldService.getSortedByRankField(savedFilter.getQuery());
        if (sortedByRankField.isInvalid()) {
            return null;
        }
        CustomField rankCustomField = sortedByRankField.get().getCustomField();
        if (rankCustomField == null) {
            return null;
        }
        return rankCustomField.getIdAsLong();
    }

    @Override
    @Nullable
    public EstimationConfig getEstimationConfig(RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return null;
        }
        StatisticsField estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView);
        EstimationConfig.Type type = statisticsConfigTypeToEstimationConfigType.get((Object)estimateStatistic.getConfig().getType());
        return new EstimationConfig(type, estimateStatistic.getField());
    }

    @Override
    public ColumnConfig getColumnConfig(@Nonnull RapidView rapidView) {
        return this.getColumnConfig(rapidView, (Function<String, Status>)((Function)arg_0 -> ((StatusManager)this.statusManager).getStatus(arg_0)), this.i18nFactoryService.getI18n());
    }

    public ColumnConfig getColumnConfig(@Nonnull RapidView rapidView, final Function<String, Status> stringToStatusFunction, final I18n2 userI18n) {
        ImmutableList columns = ImmutableList.copyOf((Iterable)Iterables.transform(this.columnService.getVisibleColumns(rapidView), (Function)new Function<com.atlassian.greenhopper.model.rapid.Column, Column>(){

            public Column apply(com.atlassian.greenhopper.model.rapid.Column column) {
                ImmutableList statuses = ImmutableList.copyOf((Iterable)Iterables.transform(column.getStatusIds(), (Function)stringToStatusFunction));
                return Column.builder().name(userI18n.getText(column.getName())).statuses((List<Status>)statuses).min(column.getMin() == null ? null : Integer.valueOf((int)Math.round(column.getMin()))).max(column.getMax() == null ? null : Integer.valueOf((int)Math.round(column.getMax()))).build();
            }
        }));
        ColumnConfig.ConstraintType constraintType = this.getColumnConfigConstraintType(rapidView);
        return new ColumnConfig((List<Column>)columns, constraintType);
    }

    private ColumnConfig.ConstraintType getColumnConfigConstraintType(RapidView rapidView) {
        ServiceOutcome<StatisticsFieldConfig> statisticsFieldConfigOutcome = this.statisticsFieldService.loadStatisticsField(rapidView);
        if (statisticsFieldConfigOutcome.isInvalid()) {
            return ColumnConfig.ConstraintType.NONE;
        }
        switch (statisticsFieldConfigOutcome.get().getType()) {
            case ISSUE_COUNT: {
                return ColumnConfig.ConstraintType.ISSUE_COUNT;
            }
            case ISSUE_COUNT_EXCL_SUBS: {
                return ColumnConfig.ConstraintType.ISSUE_COUNT_EXCL_SUBS;
            }
        }
        return ColumnConfig.ConstraintType.NONE;
    }
}

