/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.ShowEpics;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewAOMapper {
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private RapidViewPresetService rapidViewPresetService;

    public Map<String, Object> toAO(RapidView rapidView) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NAME", rapidView.getName());
        map.put("SAVED_FILTER_ID", rapidView.getSavedFilterId());
        map.put("OWNER_USER_NAME", rapidView.getOwner());
        map.put("SPRINTS_ENABLED", rapidView.isSprintSupportEnabled());
        map.put("SHOW_DAYS_IN_COLUMN", rapidView.showDaysInColumn());
        map.put("SWIMLANE_STRATEGY", rapidView.getSwimlaneStrategy().getId());
        map.put("CARD_COLOR_STRATEGY", rapidView.getCardColorStrategy().getId());
        map.put("SHOW_EPIC_AS_PANEL", rapidView.getShowEpicsAsPanel().isEnabled());
        map.put("OLD_DONE_ISSUES_CUTOFF", rapidView.getOldDoneIssuesCutoff().getValue());
        return map;
    }

    public RapidView toModel(RapidViewAO rapidViewAO) {
        String cardColorStrategyId;
        CardColorStrategy cardColorStrategy;
        String swimlaneStrategyId = rapidViewAO.getSwimlaneStrategy();
        SwimlaneStrategy swimlaneStrategy = SwimlaneStrategy.lookup(swimlaneStrategyId);
        if (swimlaneStrategy == null) {
            this.logger.info("Rapid View id=%d has unknown swimlane strategy '%s' -- setting to 'none'", rapidViewAO.getId(), swimlaneStrategyId);
            swimlaneStrategy = SwimlaneStrategy.NONE;
        }
        if ((cardColorStrategy = CardColorStrategy.lookup(cardColorStrategyId = rapidViewAO.getCardColorStrategy())) == null) {
            this.logger.info("Rapid View id=%d has unknown card color strategy '%s' -- setting to 'issuetype'", rapidViewAO.getId(), cardColorStrategyId);
            cardColorStrategy = CardColorStrategy.ISSUE_TYPE;
        }
        boolean showDaysInColumn = this.getShowDaysInColumn(rapidViewAO);
        boolean sprintsEnabled = Optional.ofNullable(rapidViewAO.isSprintsEnabled()).orElse(false);
        RapidView.OldDoneIssuesCutoff oldDoneIssuesCutoff = this.getOldDoneIssuesCutoff(rapidViewAO);
        return RapidView.builder().id(rapidViewAO.getId()).name(rapidViewAO.getName()).owner(rapidViewAO.getOwnerUserName()).savedFilterId(rapidViewAO.getSavedFilterId()).sprintSupportEnabled(sprintsEnabled).swimlaneStrategy(swimlaneStrategy).cardColorStrategy(cardColorStrategy).showDaysInColumn(showDaysInColumn).showEpicAsPanel(ShowEpics.getValueFrom(rapidViewAO.isShowEpicAsPanel())).oldDoneIssuesCutoff(oldDoneIssuesCutoff).build();
    }

    public void update(RapidView source, RapidViewAO target) {
        target.setName(source.getName());
        target.setOwnerUserName(source.getOwner());
        target.setSavedFilterId(source.getSavedFilterId());
        target.setSprintsEnabled(source.isSprintSupportEnabled());
        target.setShowDaysInColumn(source.showDaysInColumn());
        target.setSwimlaneStrategy(source.getSwimlaneStrategy().getId());
        target.setCardColorStrategy(source.getCardColorStrategy().getId());
        target.setShowEpicAsPanel(source.getShowEpicsAsPanel().getDbValue());
        target.setOldDoneIssuesCutoff(source.getOldDoneIssuesCutoff().getValue());
    }

    private boolean getShowDaysInColumn(RapidViewAO rapidViewAO) {
        Boolean aoShowDaysInColumnValue = rapidViewAO.getShowDaysInColumn();
        boolean showDaysInColumn = aoShowDaysInColumnValue == null ? this.rapidViewPresetService.getDefaultShowDaysInColumnConfig(this.getPreset(rapidViewAO)) : aoShowDaysInColumnValue.booleanValue();
        return showDaysInColumn;
    }

    private RapidView.OldDoneIssuesCutoff getOldDoneIssuesCutoff(RapidViewAO rapidViewAO) {
        return RapidView.OldDoneIssuesCutoff.fromValue(rapidViewAO.getOldDoneIssuesCutoff()).orElseGet(() -> this.rapidViewPresetService.getDefaultOldDoneIssuesCutoff(this.getPreset(rapidViewAO)));
    }

    private RapidViewPreset getPreset(RapidViewAO rapidViewAO) {
        return rapidViewAO.isSprintsEnabled() != false ? RapidViewPreset.SCRUM : RapidViewPreset.KANBAN;
    }
}

