/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAO;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAOMapper;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterDao;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuickFilterServiceImpl
implements QuickFilterService {
    private static final int QUICK_FILTER_NAME_MAX_LENGTH = 255;
    private static final int QUICK_FILTER_DESCRIPTION_MAX_LENGTH = 255;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private QuickFilterDao quickFilterDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private QuickFilterAOMapper quickFilterAOMapper;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, ImmutableList<QuickFilter>> quickFilterCache;

    @PostConstruct
    public void init() {
        this.quickFilterCache = this.cacheFactoryManager.create().getCache(QuickFilterServiceImpl.class.getName() + ".quickFilterCache", new QuickFilterCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public List<QuickFilter> copy(List<QuickFilter> sourceQuickFilters) {
        ArrayList<QuickFilter> copiedQuickFilters = new ArrayList<QuickFilter>();
        for (QuickFilter sourceQuickFilter : sourceQuickFilters) {
            QuickFilter copiedQuickFilter = QuickFilter.builder(sourceQuickFilter).id(null).build();
            copiedQuickFilters.add(copiedQuickFilter);
        }
        return copiedQuickFilters;
    }

    @Override
    public List<QuickFilter> loadQuickFilters(RapidView rapidView) {
        ImmutableList<QuickFilter> quickFilters = this.quickFilterCache.get(rapidView.getId());
        return quickFilters;
    }

    @Override
    public QuickFilter get(ApplicationUser user, RapidView rapidView, long quickFilterId, ErrorCollection errors) {
        List<QuickFilter> quickFilters = (List<QuickFilter>)this.quickFilterCache.get(rapidView.getId());
        if (quickFilters == null && (quickFilters = this.loadQuickFilters(rapidView)) == null) {
            errors.addError("gh.rapid.view.error.rapidview.id.invalid", quickFilterId);
            return null;
        }
        for (QuickFilter quickFilter : quickFilters) {
            if (!quickFilter.getId().equals(quickFilterId)) continue;
            return quickFilter;
        }
        errors.addError("gh.rapid.view.error.quickfilter.id.invalid", quickFilterId);
        return null;
    }

    @Override
    @Nonnull
    public ServiceOutcome<QuickFilter> add(ApplicationUser user, RapidView rapidView, QuickFilter quickFilter) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        ErrorCollection errors = new ErrorCollection();
        this.validateQuickFilter(user, quickFilter, errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        Object quickFilters = this.quickFilterAOMapper.toModel(this.quickFilterDao.getForParent(rapidView.getId()));
        quickFilters.add(0, (QuickFilter)quickFilter);
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<QuickFilterAO> updatedQuickFilters = this.quickFilterDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), (List<QuickFilter>)quickFilters);
        this.quickFilterCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.quickFilterAOMapper.toModel(updatedQuickFilters.get(0)));
    }

    @Override
    public QuickFilter update(ApplicationUser user, RapidView rapidView, QuickFilter quickFilter, ErrorCollection errors) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            errors.addAllErrors(validatedPermission.getErrors());
            return null;
        }
        Object quickFilters = this.quickFilterAOMapper.toModel(this.quickFilterDao.getForParent(rapidView.getId()));
        QuickFilter existingQuickFilter = this.findById((List<QuickFilter>)quickFilters, quickFilter.getId());
        if (existingQuickFilter == null) {
            errors.addError("gh.rapid.view.error.quickfilter.id.invalid", quickFilter.getId());
            return null;
        }
        this.validateQuickFilter(user, quickFilter, errors);
        if (errors.hasErrors()) {
            return null;
        }
        QuickFilterAO updatedQuickFilter = this.quickFilterDao.updateQuickFilter(quickFilter, errors);
        if (errors.hasErrors()) {
            return null;
        }
        this.quickFilterCache.remove(rapidView.getId());
        return this.quickFilterAOMapper.toModel(updatedQuickFilter);
    }

    @Override
    @Nonnull
    public ServiceOutcome<List<QuickFilter>> set(ApplicationUser user, RapidView rapidView, List<QuickFilter> quickFilters) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        ErrorCollection errors = new ErrorCollection();
        for (QuickFilter quickFilter : quickFilters) {
            this.validateQuickFilter(user, quickFilter, errors);
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<QuickFilterAO> quickFilterAOs = this.quickFilterDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), quickFilters);
        quickFilters = this.quickFilterAOMapper.toModel(quickFilterAOs);
        this.quickFilterCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(quickFilters);
    }

    @Override
    public void delete(ApplicationUser user, RapidView rapidView, long quickFilterId, ErrorCollection errors) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            errors.addAllErrors(validatedPermission.getErrors());
            return;
        }
        Object quickFilters = this.quickFilterAOMapper.toModel(this.quickFilterDao.getForParent(rapidView.getId()));
        QuickFilter existingQuickFilter = this.findById((List<QuickFilter>)quickFilters, quickFilterId);
        if (existingQuickFilter == null) {
            errors.addError("gh.rapid.view.error.quickfilter.id.invalid", quickFilterId);
            return;
        }
        quickFilters.remove(existingQuickFilter);
        this.updateQuickFilters(rapidView, (List<QuickFilter>)quickFilters);
        this.quickFilterCache.remove(rapidView.getId());
    }

    @Override
    public ServiceOutcome<Void> moveAfter(ApplicationUser user, RapidView rapidView, long quickFilterId, Long moveToQuickFilterId) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        Object quickFilters = this.quickFilterAOMapper.toModel(this.quickFilterDao.getForParent(rapidView.getId()));
        QuickFilter quickFilter = this.findById((List<QuickFilter>)quickFilters, quickFilterId);
        if (quickFilter == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.quickfilter.id.invalid", quickFilterId);
        }
        QuickFilter targetQuickFilter = null;
        if (moveToQuickFilterId != null && (targetQuickFilter = this.findById((List<QuickFilter>)quickFilters, moveToQuickFilterId)) == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.quickfilter.id.invalid", moveToQuickFilterId);
        }
        quickFilters.remove(quickFilter);
        int insertIndex = targetQuickFilter != null ? quickFilters.indexOf(targetQuickFilter) + 1 : 0;
        quickFilters.add(insertIndex, (QuickFilter)quickFilter);
        this.updateQuickFilters(rapidView, (List<QuickFilter>)quickFilters);
        this.quickFilterCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public void invalidate(RapidView view) {
        this.quickFilterCache.remove(view.getId());
    }

    private ServiceOutcome<Void> updateQuickFilters(RapidView rapidView, List<QuickFilter> quickFilters) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        this.quickFilterDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), quickFilters);
        this.quickFilterCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    private void validateQuickFilter(ApplicationUser user, QuickFilter quickFilter, ErrorCollection errors) {
        this.validateName(quickFilter.getName(), errors);
        this.validateQuery(quickFilter.getQuery(), user, errors);
        this.validateDescription(quickFilter.getDescription(), errors);
    }

    private void validateQuery(String query, ApplicationUser user, ErrorCollection errors) {
        this.jqlHelper.validateJql(user, query, "query", errors);
    }

    private void validateName(String name, ErrorCollection errors) {
        if (StringUtils.isBlank((CharSequence)name)) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.rapid.view.error.name.required", new Object[0]);
        } else if (name.length() > 255) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.rapid.view.error.string.too.long", "Name", 255);
        }
    }

    private void validateDescription(String description, ErrorCollection errors) {
        if (description == null) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "description", "Description must not be null", new Object[0]);
        } else if (description.length() > 255) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "description", "gh.rapid.view.error.string.too.long", "Description", 255);
        }
    }

    private QuickFilter findById(List<QuickFilter> quickFilters, long quickFilterId) {
        for (QuickFilter quickFilter : quickFilters) {
            if (quickFilter.getId() != quickFilterId) continue;
            return quickFilter;
        }
        return null;
    }

    @Override
    public void flushCache() {
        this.quickFilterCache.removeAll();
    }

    private class QuickFilterCacheLoader
    implements CacheLoader<Long, ImmutableList<QuickFilter>> {
        private QuickFilterCacheLoader() {
        }

        @Override
        public ImmutableList<QuickFilter> load(@Nonnull Long rapidViewId) {
            QuickFilterAO[] quickFilterAOs = QuickFilterServiceImpl.this.quickFilterDao.getForParent(rapidViewId);
            Object mutableList = QuickFilterServiceImpl.this.quickFilterAOMapper.toModel(quickFilterAOs);
            return ImmutableList.copyOf(mutableList);
        }
    }
}

