/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAO;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAOListMapper;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAOMapper;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuickFilterDao
extends GenericActiveObjectsDao<Long, QuickFilterAO>
implements RelatedEntityDao<Long, RapidViewAO, QuickFilterAO, QuickFilter> {
    @Autowired
    private QuickFilterAOMapper quickFilterAOMapper;

    public QuickFilterAO[] getForParent(RapidViewAO parent) {
        return this.getForParent(parent.getId());
    }

    public QuickFilterAO[] getForParent(Long rapidViewId) {
        return (QuickFilterAO[])this.ao.find(QuickFilterAO.class, "RAPID_VIEW_ID = ?", new Object[]{rapidViewId});
    }

    public QuickFilterAO getQuickFilter(long rapidViewId, long quickFilterId) {
        QuickFilterAO[] quickFilter = (QuickFilterAO[])this.ao.find(QuickFilterAO.class, "RAPID_VIEW_ID = ? and ID = ?", new Object[]{rapidViewId, quickFilterId});
        return quickFilter.length > 0 ? quickFilter[0] : null;
    }

    public QuickFilterAO updateQuickFilter(QuickFilter quickFilter, ErrorCollection errors) {
        QuickFilterAO quickFilterAO = (QuickFilterAO)this.ao.get(QuickFilterAO.class, (Object)quickFilter.getId());
        if (quickFilterAO == null) {
            errors.addError("QuickFilter with id {0} not found", quickFilter.getId());
            return null;
        }
        this.quickFilterAOMapper.update(quickFilter, quickFilterAO);
        quickFilterAO.save();
        return quickFilterAO;
    }

    @Override
    public List<QuickFilterAO> updateForParent(RapidViewAO rapidViewAO, List<QuickFilter> quickFilters) {
        return AOUtil.setListValues(this.ao, new QuickFilterAOListMapper(rapidViewAO, this.quickFilterAOMapper), quickFilters);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        this.delete(rapidViewAO.getQuickFilters());
    }

    public int count() {
        return this.ao.count(QuickFilterAO.class);
    }
}

