/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.AbstractAOMapper;
import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class QuickFilterAOMapper
extends AbstractAOMapper<QuickFilterAO, QuickFilter>
implements RelatedAOMapper<RapidViewAO, QuickFilterAO, QuickFilter> {
    @Override
    public Map<String, Object> toAO(RapidViewAO rapidViewAO, QuickFilter quickFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(quickFilter));
        map.put("RAPID_VIEW_ID", rapidViewAO);
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(QuickFilter quickFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NAME", quickFilter.getName());
        map.put("LONG_QUERY", quickFilter.getQuery());
        map.put("DESCRIPTION", quickFilter.getDescription());
        map.put("POS", quickFilter.getPosition());
        return map;
    }

    @Override
    @Nonnull
    public QuickFilter toModel(QuickFilterAO quickFilterAO) {
        String query = quickFilterAO.getLongQuery();
        if (query == null) {
            query = quickFilterAO.getQuery();
        }
        return QuickFilter.builder().id(quickFilterAO.getId()).name(quickFilterAO.getName()).description(quickFilterAO.getDescription()).query(query).position(quickFilterAO.getPos()).build();
    }

    @Override
    public void update(QuickFilter source, QuickFilterAO target) {
        target.setDescription(source.getDescription());
        target.setName(source.getName());
        target.setLongQuery(source.getQuery());
        if (target.getQuery() != null) {
            target.setQuery(null);
        }
    }
}

