/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.api.events.board.KanbanBacklogToggledEvent;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.ShowEpics;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.KanbanBacklogColumnService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

public class KanbanBacklogColumnServiceImpl
implements KanbanBacklogColumnService {
    @Autowired
    private ColumnService columnService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    public RapidViewManager rapidViewManager;
    @Autowired
    private EventPublisher eventPublisher;
    private static final int KANPLAN_AUTO_CONVERT_COLUMN_LIMIT = 3;
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void cleanup() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public ServiceOutcome<List<Column>> disbandBacklogColumn(ApplicationUser user, RapidView rapidView) {
        List<Column> allColumns = this.columnService.getAllColumns(rapidView);
        Column kanbanBacklogColumn = allColumns.stream().filter(KanbanBacklogColumn::isKanbanBacklogColumn).findFirst().orElse(null);
        if (kanbanBacklogColumn != null) {
            KanbanBacklogColumn wipedOutKanbanBacklogColumn = KanbanBacklogColumn.newKanbanBacklogColumn(kanbanBacklogColumn.getId(), Collections.emptyList());
            allColumns.set(0, wipedOutKanbanBacklogColumn);
            return this.columnService.updateColumns(user, rapidView, allColumns);
        }
        return ServiceOutcomeImpl.ok(allColumns);
    }

    @Override
    public ServiceOutcome<KanbanBacklogColumn> getBacklogColumn(ApplicationUser user, RapidView rapidView) {
        return this.columnService.getKanbanBacklogColumn(rapidView);
    }

    @Override
    public ServiceOutcome<List<Column>> migrateBacklogColumn(ApplicationUser user, RapidView rapidView) {
        List<Column> allColumns = this.columnService.getAllColumns(rapidView);
        List<Column> mappedColumns = this.columnService.getValidColumns(rapidView);
        if (!this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.kanplan.error.feature.not.enabled", new Object[0]);
        }
        if (rapidView.getType() != RapidView.Type.KANBAN) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.kanplan.autoconvert.failed.notkanbanboard", new Object[0]);
        }
        if (mappedColumns.size() < 3) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.kanplan.autoconvert.failed.columnlimit", new Object[0]);
        }
        Column emptyKanbanBacklog = allColumns.get(0);
        if (!this.isKanbanBacklogColumn(emptyKanbanBacklog)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.kanplan.autoconvert.failed.nokanplancolumn", new Object[0]);
        }
        if (!emptyKanbanBacklog.getStatusIds().isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.kanplan.autoconvert.failed.already.mapped", new Object[0]);
        }
        Column oldBacklogColumn = mappedColumns.get(0);
        KanbanBacklogColumn kanbanBacklogColumn = KanbanBacklogColumn.newKanbanBacklogColumn(emptyKanbanBacklog.getId(), oldBacklogColumn.getStatusIds());
        allColumns.set(0, kanbanBacklogColumn);
        Column emptyOldBacklogColumn = Column.builder(oldBacklogColumn).statusIds(Collections.emptyList()).build();
        Collections.replaceAll(allColumns, oldBacklogColumn, emptyOldBacklogColumn);
        return this.columnService.updateColumns(user, rapidView, allColumns);
    }

    @EventListener
    public void enableEpicsPanelWhenKanPlanEnabled(KanbanBacklogToggledEvent event) {
        RapidView newRapidView;
        ServiceOutcome<Void> result;
        if (event.getNewState() && event.getBoard().getShowEpicsAsPanel() != ShowEpics.DEFAULT && (result = this.rapidViewManager.update(newRapidView = RapidView.builder(event.getBoard()).showEpicAsPanel(ShowEpics.YES).build())).isInvalid()) {
            this.log.error(result.getErrors());
        }
    }

    boolean isKanbanBacklogColumn(Column column) {
        return KanbanBacklogColumn.isKanbanBacklogColumn(column);
    }
}

