/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class GenericActiveObjectsDao<PK, E extends RawEntity<PK>> {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    protected ActiveObjects ao;
    protected final Class<E> entityType;

    public GenericActiveObjectsDao() {
        Type[] params = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.entityType = params.length == 1 ? (Class)params[0] : (Class)params[1];
    }

    public ServiceOutcome<E> load(PK primaryKey) {
        RawEntity entity = this.ao.get(this.entityType, primaryKey);
        if (entity != null) {
            this.log.debug("loaded entity %s for id %s", entity, primaryKey);
            return ServiceOutcomeImpl.ok(entity);
        }
        String message = "could not find entity of type " + this.entityType + " with key " + primaryKey;
        this.log.debug(message, new Object[0]);
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, message, new Object[0]);
    }

    public E create(Map<String, Object> fields) {
        this.log.debug("creating a new entity of type %s with fields %s", this.entityType.getName(), fields);
        return (E)this.ao.create(this.entityType, fields);
    }

    public void save(E entity) {
        this.log.debug("saving entity of type %s", this.entityType);
        entity.save();
    }

    public void delete(PK primaryKey) {
        this.log.debug("deleting entity of type %s with primary key = %s", this.entityType.getName(), primaryKey);
        RawEntity entity = this.ao.get(this.entityType, primaryKey);
        if (entity != null) {
            this.delete((PK)new RawEntity[]{entity});
        }
    }

    public void delete(E ... entities) {
        this.log.debug("deleting %d entities of type %s", entities.length, this.entityType.getName());
        this.preDelete((RawEntity[])entities);
        this.ao.delete(entities);
    }

    protected void preDelete(E ... entities) {
    }

    protected E[] findBy(String query, Object ... parameters) {
        return this.ao.find(this.entityType, query, parameters);
    }

    public void flushAll() {
        this.ao.flushAll();
    }
}

