/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.events.board.BoardEventPublisher;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.BacklogColumnHelper;
import com.atlassian.greenhopper.service.rapid.view.ColumnAO;
import com.atlassian.greenhopper.service.rapid.view.ColumnDao;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.Positionable;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ColumnServiceImpl
implements ColumnService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final int MAX_ISSUE_COUNT_LIMIT = 1000;
    @Autowired
    private ColumnDao columnDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    @Autowired
    private BoardEventPublisher boardEventPublisher;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private ClusterLockService clusterLockService;
    @Autowired
    private BacklogColumnHelper backlogColumnHelper;
    @Autowired
    private StatusService statusService;
    private Cache<Long, ImmutableList<Column>> columnCache;

    @PostConstruct
    public void init() {
        this.columnCache = this.cacheFactoryManager.create().getCache(ColumnServiceImpl.class.getName() + ".columnCache", new ColumnCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public ServiceOutcome<Column> getColumn(Long id) {
        ServiceOutcome outcome = this.columnDao.load(id);
        return outcome.isValid() ? ServiceOutcomeImpl.ok(this.fromAO((ColumnAO)outcome.getValue())) : ServiceOutcomeImpl.error(outcome);
    }

    @Override
    @Nonnull
    public List<Column> getVisibleColumns(RapidView rapidView) {
        List<Column> columns = this.getAllColumns(rapidView);
        boolean hasKanbanBacklogReturned = columns.stream().anyMatch(KanbanBacklogColumn::isKanbanBacklogColumn);
        if (hasKanbanBacklogReturned && !this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            return columns.stream().filter(column -> !KanbanBacklogColumn.isKanbanBacklogColumn(column)).collect(Collectors.toList());
        }
        return columns;
    }

    @Override
    @Nonnull
    public List<Column> getAllColumns(RapidView rapidView) {
        ImmutableList<Column> immutableColumns = this.getAllColumnsNoUpdate(rapidView);
        ArrayList columns = Lists.newArrayList(immutableColumns);
        this.backlogColumnHelper.addBacklogColumnIfNeededAndPerformCleanup(rapidView, columns, this::updateColumns, this::getAllColumnsNoUpdate);
        return columns;
    }

    private ImmutableList<Column> getAllColumnsNoUpdate(RapidView rapidView) {
        return this.columnCache.get(rapidView.getId());
    }

    @Override
    @Nonnull
    public ColumnService.ColumnProgressMap getProgressStatuses(RapidView view) {
        List<Column> columns = this.getVisibleColumns(view);
        LinkedHashSet<Status> notStarted = new LinkedHashSet<Status>();
        LinkedHashSet<Status> inProgress = new LinkedHashSet<Status>();
        LinkedHashSet<Status> done = new LinkedHashSet<Status>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (i == 0) {
                notStarted.addAll(this.getStatuses(column));
                continue;
            }
            if (i == columns.size() - 1) {
                done.addAll(this.getStatuses(column));
                continue;
            }
            inProgress.addAll(this.getStatuses(column));
        }
        return new ColumnService.ColumnProgressMap(notStarted, inProgress, done);
    }

    @Override
    public Set<Status> getMappedStatuses(RapidView view) {
        HashSet<Status> statuses = new HashSet<Status>();
        for (Column column : this.getVisibleColumns(view)) {
            statuses.addAll(this.getStatuses(column));
        }
        return statuses;
    }

    @Override
    public Map<Status, Column> getColumnsByStatus(RapidView view) {
        HashMap<Status, Column> map = new HashMap<Status, Column>();
        for (Column column : this.getVisibleColumns(view)) {
            for (Status status : this.getStatuses(column)) {
                map.put(status, column);
            }
        }
        return map;
    }

    @Override
    @Nonnull
    public List<Status> getDoneStatuses(Column column, ApplicationUser user) {
        return column.getStatusIds().stream().map(statusId -> this.statusService.getStatusById(user, statusId)).filter(status -> status.getStatusCategory().getKey().equals("done")).collect(Collectors.toList());
    }

    private Set<Status> getStatuses(Column column) {
        HashSet<Status> statuses = new HashSet<Status>();
        for (String statusId : column.getStatusIds()) {
            Status status = this.workflowService.getWorkflowStatusObject(statusId);
            if (status == null) continue;
            statuses.add(status);
        }
        return statuses;
    }

    @Override
    public List<Column> getValidColumns(RapidView view) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column column : this.getVisibleColumns(view)) {
            if (column.getStatusIds().isEmpty()) continue;
            columns.add(column);
        }
        return columns;
    }

    @Override
    public boolean isKanPlanEnabledForBoard(RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled() && this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            ServiceOutcome<KanbanBacklogColumn> kanbanBacklogColumn = this.getKanbanBacklogColumn(rapidView);
            return kanbanBacklogColumn.isValid() && kanbanBacklogColumn.get().isKanbanBacklogMapped();
        }
        return false;
    }

    private boolean isKanPlanEnabled(RapidView rapidView, List<Column> columns) {
        if (!rapidView.isSprintSupportEnabled() && this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            return this.backlogColumnHelper.getKanbanBacklogColumn(columns).map(KanbanBacklogColumn::isKanbanBacklogMapped).orElse(false);
        }
        return false;
    }

    @Override
    @Nonnull
    public ServiceOutcome<KanbanBacklogColumn> getKanbanBacklogColumn(RapidView rapidView) {
        return this.backlogColumnHelper.getKanbanBacklogColumn(this.getAllColumns(rapidView)).map(ServiceOutcomeImpl::ok).orElse(ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.boards.kanplan.error.no.backlog.column", new Object[0]));
    }

    @Override
    @Nonnull
    public List<Status> getOrderedStatuses(RapidView view) {
        ArrayList<Status> orderedStatuses = new ArrayList<Status>();
        for (Column column : this.getVisibleColumns(view)) {
            for (String statusId : column.getStatusIds()) {
                Status status = this.workflowService.getWorkflowStatusObject(statusId);
                if (status == null) continue;
                orderedStatuses.add(status);
            }
        }
        return orderedStatuses;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Column> addColumn(ApplicationUser user, RapidView rapidView, Column sourceColumn) {
        if (StringUtils.isBlank((CharSequence)sourceColumn.getName())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.columns.error.no.name", new Object[0]);
        }
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        Column columnToAdd = Column.builder(sourceColumn).id(null).build();
        ArrayList<Column> newColumns = new ArrayList<Column>(this.getVisibleColumns(rapidView));
        int newPosition = ColumnServiceImpl.computeColumnPosition(sourceColumn, newColumns);
        newColumns.add(newPosition, columnToAdd);
        ServiceOutcome<List<Column>> result = this.updateColumns(user, rapidView, newColumns);
        if (!result.isValid()) {
            return ServiceOutcomeImpl.error(result);
        }
        return ServiceOutcomeImpl.ok(result.getValue().get(newPosition));
    }

    private static int computeColumnPosition(Column sourceColumn, List<Column> newColumns) {
        return KanbanBacklogColumn.isKanbanBacklogColumn(sourceColumn) || newColumns.isEmpty() ? 0 : newColumns.size() - 1;
    }

    @Override
    public Map<Column, Integer> getColumnPositions(RapidView rapidView) {
        HashMap<Column, Integer> map = new HashMap<Column, Integer>();
        List<Column> columns = this.getVisibleColumns(rapidView);
        for (int i = 0; i < columns.size(); ++i) {
            map.put(columns.get(i), i);
        }
        return map;
    }

    private List<Column> fromAO(ColumnAO[] columnAOs, ErrorCollection errors) {
        AOUtil.sortPositionableArray((Positionable[])columnAOs);
        ArrayList<Column> columns = new ArrayList<Column>();
        for (ColumnAO columnAO : columnAOs) {
            columns.add(this.fromAO(columnAO));
        }
        return columns;
    }

    private Column fromAO(ColumnAO columnAO) {
        if (KanbanBacklogColumn.isKanbanBacklogColumnByName(columnAO.getName())) {
            return KanbanBacklogColumn.newKanbanBacklogColumn(columnAO.getId(), this.validateStatusIds(columnAO));
        }
        return Column.builder().id(columnAO.getId()).name(StringUtils.defaultString((String)columnAO.getName())).max(columnAO.getMaxim()).min(columnAO.getMinim()).statusIds(this.validateStatusIds(columnAO)).build();
    }

    private List<String> validateStatusIds(ColumnAO columnAO) {
        Positionable[] statusAOs = columnAO.getStatuses();
        AOUtil.sortPositionableArray((Positionable[])statusAOs);
        ArrayList<String> statusIds = new ArrayList<String>();
        for (Positionable statusAO : statusAOs) {
            Status status = this.workflowService.getWorkflowStatusObject(statusAO.getStatusId());
            if (status != null) {
                statusIds.add(status.getId());
                continue;
            }
            this.log.info("Invalid status [id %d] mapped to column [id %d], ignoring", statusAO.getStatusId(), columnAO.getId());
        }
        return statusIds;
    }

    @Override
    public synchronized ServiceOutcome<List<Column>> updateColumns(ApplicationUser user, RapidView rapidView, List<Column> newColumns) {
        ServiceOutcome<Void> validatedPermission = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!validatedPermission.isValid()) {
            return ServiceOutcomeImpl.error(validatedPermission);
        }
        return this.updateColumns(rapidView, newColumns);
    }

    private ServiceOutcome<List<Column>> updateColumns(RapidView rapidView, List<Column> newColumns) {
        ErrorCollection errors = new ErrorCollection();
        this.validateColumns(rapidView, newColumns, errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        ImmutableList<Column> oldColumns = this.getAllColumnsNoUpdate(rapidView);
        List<ColumnAO> columnAOs = this.columnDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), newColumns);
        List<Column> columns = this.fromAO(columnAOs.toArray(new ColumnAO[0]), errors);
        this.columnCache.remove(rapidView.getId());
        this.boardEventPublisher.publishBoardConfigurationChangedEvent(rapidView);
        if (this.wasKanbanBacklogToggled(rapidView, (List<Column>)oldColumns, newColumns)) {
            this.boardEventPublisher.publishKanbanBacklogToggledEvent(rapidView, this.isKanPlanEnabledForBoard(rapidView));
        }
        return ServiceOutcomeImpl.ok(columns);
    }

    private boolean wasKanbanBacklogToggled(RapidView rapidView, List<Column> oldColumns, List<Column> newColumns) {
        return this.isKanPlanEnabled(rapidView, oldColumns) != this.isKanPlanEnabled(rapidView, newColumns);
    }

    @Override
    public void validateColumns(List<Column> columns, ErrorCollection errors) {
        HashSet<String> seenStatusIds = new HashSet<String>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (StringUtils.isBlank((CharSequence)column.getName())) {
                errors.addContextualError("column." + i + ".name", "gh.rapid.view.error.name.required", new Object[0]);
            }
            for (String statusId : column.getStatusIds()) {
                if (seenStatusIds.contains(statusId)) {
                    Status status = this.workflowService.getWorkflowStatusObject(statusId);
                    String name = status != null ? status.getNameTranslation() : statusId;
                    errors.addContextualError("column." + i + ".name", "gh.rapid.view.error.status.repeated", name);
                    continue;
                }
                seenStatusIds.add(statusId);
            }
            Double columnMin = column.getMin();
            Double columnMax = column.getMax();
            this.checkColumnConstraint(i, columnMin, ".min", errors);
            this.checkColumnConstraint(i, columnMax, ".max", errors);
            if (columnMin == null || columnMax == null || !(columnMin > columnMax)) continue;
            errors.addContextualError("column." + i + ".min", "gh.rapid.view.error.mintoobig", new Object[0]);
        }
    }

    @Override
    public void validateColumns(RapidView rapidView, List<Column> columns, ErrorCollection errors) {
        this.validateColumns(columns, errors);
        boolean hasKanbanBacklogReturned = columns.stream().anyMatch(KanbanBacklogColumn::isKanbanBacklogColumn);
        if (!hasKanbanBacklogReturned && this.isKanPlanEnabledForBoard(rapidView)) {
            errors.addError("gh.boards.kanplan.error.no.backlog.column", new Object[0]);
        }
    }

    @Override
    public void invalidate(RapidView view) {
        this.columnCache.remove(view.getId());
    }

    @Override
    public void flushCache() {
        this.columnCache.removeAll();
    }

    private void checkColumnConstraint(int columnIndex, Double constraintVal, String constraintSuffix, ErrorCollection errors) {
        if (constraintVal != null) {
            if (constraintVal < 0.0) {
                errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "column." + columnIndex + constraintSuffix, "gh.rapid.view.error.capacity.toosmall", 0);
            } else if (constraintVal >= 1000.0) {
                errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "column." + columnIndex + constraintSuffix, "gh.rapid.view.error.capacity.toobig", 1000);
            }
        }
    }

    private class ColumnCacheLoader
    implements CacheLoader<Long, ImmutableList<Column>> {
        private ColumnCacheLoader() {
        }

        @Override
        public ImmutableList<Column> load(@Nonnull Long rapidViewId) {
            ArrayList<Column> mutableColumns = new ArrayList<Column>();
            for (ColumnAO columnAO : ColumnServiceImpl.this.columnDao.getForParent(rapidViewId)) {
                mutableColumns.add(ColumnServiceImpl.this.fromAO(columnAO));
            }
            return ImmutableList.copyOf(mutableColumns);
        }
    }
}

