/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.ColumnProgress;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public interface ColumnService
extends GreenHopperCache {
    public static final int KANBAN_BACKLOG_COLUMN_POSITION = 0;

    public ServiceOutcome<Column> getColumn(Long var1);

    @Nonnull
    public List<Column> getVisibleColumns(RapidView var1);

    @Nonnull
    public List<Column> getAllColumns(RapidView var1);

    @Nonnull
    public ColumnProgressMap getProgressStatuses(RapidView var1);

    public Set<Status> getMappedStatuses(RapidView var1);

    public Map<Status, Column> getColumnsByStatus(RapidView var1);

    @Nonnull
    public List<Status> getDoneStatuses(Column var1, ApplicationUser var2);

    public List<Column> getValidColumns(RapidView var1);

    public boolean isKanPlanEnabledForBoard(RapidView var1);

    @Nonnull
    public ServiceOutcome<KanbanBacklogColumn> getKanbanBacklogColumn(RapidView var1);

    @Nonnull
    public List<Status> getOrderedStatuses(RapidView var1);

    @Nonnull
    public ServiceOutcome<Column> addColumn(ApplicationUser var1, RapidView var2, Column var3);

    @Transactional
    public ServiceOutcome<List<Column>> updateColumns(ApplicationUser var1, RapidView var2, List<Column> var3);

    @Deprecated
    public void validateColumns(List<Column> var1, ErrorCollection var2);

    public void validateColumns(RapidView var1, List<Column> var2, ErrorCollection var3);

    public Map<Column, Integer> getColumnPositions(RapidView var1);

    public void invalidate(RapidView var1);

    public static class ColumnProgressMap {
        private final Map<ColumnProgress, Set<Status>> progressToStatuses = new LinkedHashMap<ColumnProgress, Set<Status>>();

        public ColumnProgressMap(Set<Status> notStarted, Set<Status> inProgress, Set<Status> done) {
            this.progressToStatuses.put(ColumnProgress.NOT_STARTED, notStarted);
            this.progressToStatuses.put(ColumnProgress.IN_PROGRESS, inProgress);
            this.progressToStatuses.put(ColumnProgress.DONE, done);
        }

        public Set<Status> getNotStarted() {
            return this.progressToStatuses.get((Object)ColumnProgress.NOT_STARTED);
        }

        public Set<Status> getInProgress() {
            return this.progressToStatuses.get((Object)ColumnProgress.IN_PROGRESS);
        }

        public Set<Status> getDone() {
            return this.progressToStatuses.get((Object)ColumnProgress.DONE);
        }

        public Map<ColumnProgress, Set<Status>> getProgressToStatuses() {
            return this.progressToStatuses;
        }

        public ColumnProgress resolve(Status status) {
            for (Map.Entry<ColumnProgress, Set<Status>> entry : this.progressToStatuses.entrySet()) {
                if (!entry.getValue().contains(status)) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

