/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.ColumnAO;
import com.atlassian.greenhopper.service.rapid.view.ColumnAOListMapper;
import com.atlassian.greenhopper.service.rapid.view.ColumnAOMapper;
import com.atlassian.greenhopper.service.rapid.view.ColumnStatusAO;
import com.atlassian.greenhopper.service.rapid.view.ColumnStatusDao;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.ObjectNotFoundException;
import com.atlassian.greenhopper.service.rapid.view.Positionable;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ColumnDao
extends GenericActiveObjectsDao<Long, ColumnAO>
implements RelatedEntityDao<Long, RapidViewAO, ColumnAO, Column> {
    @Autowired
    private ColumnStatusDao columnStatusDao;
    @Autowired
    private ColumnAOMapper columnAOMapper;

    public ColumnAO getColumn(long columnId) {
        ColumnAO[] columnAOs = (ColumnAO[])this.ao.find(ColumnAO.class, "ID = ?", new Object[]{columnId});
        if (columnAOs.length != 1) {
            throw new ObjectNotFoundException(columnId, ColumnAO.class);
        }
        return columnAOs[0];
    }

    public ColumnAO[] getForParent(RapidViewAO parent) {
        return this.getForParent(parent.getId());
    }

    public ColumnAO[] getForParent(Long rapidViewId) {
        Positionable[] elements = (ColumnAO[])this.ao.find(ColumnAO.class, "RAPID_VIEW_ID = ?", new Object[]{rapidViewId});
        AOUtil.sortPositionableArray((Positionable[])elements);
        return elements;
    }

    @Override
    public List<ColumnAO> updateForParent(RapidViewAO rapidView, List<Column> columns) {
        return AOUtil.setListValues(this.ao, new ColumnAOListMapper(rapidView, this.columnAOMapper, this.ao), columns);
    }

    public ColumnAO createWithStatuses(Map<String, Object> stringObjectMap, List<String> statusIds, int position) {
        stringObjectMap.put("POS", position);
        ColumnAO column = (ColumnAO)this.create(stringObjectMap);
        for (int i = 0; i < statusIds.size(); ++i) {
            String statusId = statusIds.get(i);
            this.columnStatusDao.create(MapBuilder.build((Object)"STATUS_ID", (Object)statusId, (Object)"COLUMN_ID", (Object)column, (Object)"POS", (Object)i));
        }
        return column;
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        this.delete(rapidViewAO.getColumns());
    }

    protected void preDelete(ColumnAO ... entities) {
        for (ColumnAO columnAO : entities) {
            for (ColumnStatusAO status : columnAO.getStatuses()) {
                this.columnStatusDao.delete(new ColumnStatusAO[]{status});
            }
        }
    }
}

