/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.service.rapid.view.ColumnAO;
import com.atlassian.greenhopper.service.rapid.view.ColumnStatusAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class ColumnAOMapper
implements RelatedAOMapper<RapidViewAO, ColumnAO, Column> {
    @Override
    public Map<String, Object> toAO(RapidViewAO rapidViewAO, Column model) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(model));
        map.put("RAPID_VIEW_ID", rapidViewAO);
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(Column model) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NAME", KanbanBacklogColumn.isKanbanBacklogColumn(model) ? KanbanBacklogColumn.KANBAN_BACKLOG_SIGNATURE : model.getName());
        map.put("MINIM", model.getMin());
        map.put("MAXIM", model.getMax());
        return map;
    }

    @Override
    @Nonnull
    public Column toModel(ColumnAO entityAO) {
        if (KanbanBacklogColumn.isKanbanBacklogColumnByName(entityAO.getName())) {
            List<String> statusIds = Arrays.asList(entityAO.getStatuses()).stream().map(ColumnStatusAO::getStatusId).collect(Collectors.toList());
            return KanbanBacklogColumn.newKanbanBacklogColumn(entityAO.getId(), statusIds);
        }
        Column.ColumnBuilder columnBuilder = Column.builder().id(entityAO.getId()).max(entityAO.getMaxim()).min(entityAO.getMinim()).name(entityAO.getName());
        for (ColumnStatusAO statusAO : entityAO.getStatuses()) {
            columnBuilder.statusId(statusAO.getStatusId());
        }
        return columnBuilder.build();
    }

    @Override
    public void update(Column source, ColumnAO target) {
        target.setMaxim(source.getMax());
        target.setMinim(source.getMin());
        String name = KanbanBacklogColumn.isKanbanBacklogColumn(source) ? KanbanBacklogColumn.KANBAN_BACKLOG_SIGNATURE : source.getName();
        target.setName(name);
    }
}

