/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.BoardPropertyService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.event.BoardPropertyDeletedEvent;
import com.atlassian.greenhopper.service.rapid.view.event.BoardPropertySetEvent;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.event.entity.EntityPropertyDeletedEvent;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardPropertyHelper
implements EntityPropertyHelper<RapidView> {
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewManager rapidViewManager;

    public EntityPropertyHelper.CheckPermissionFunction<RapidView> hasEditPermissionFunction() {
        return (user, rapidView) -> this.permissionCheckToErrorCollection(this.rapidViewPermissionService.canEdit((ApplicationUser)user, (RapidView)rapidView));
    }

    public EntityPropertyHelper.CheckPermissionFunction<RapidView> hasReadPermissionFunction() {
        return (user, rapidView) -> this.permissionCheckToErrorCollection(this.rapidViewPermissionService.canSeeRapidView((ApplicationUser)user, (RapidView)rapidView));
    }

    public Function<Long, Option<RapidView>> getEntityByIdFunction() {
        return id -> this.rapidViewManager.get((Long)id).fold(e -> Option.none(RapidView.class), Option::option);
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertySetEvent> createSetPropertyEventBiFunction() {
        return (user, property) -> new BoardPropertySetEvent((EntityProperty)property, (ApplicationUser)user);
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return (user, property) -> new BoardPropertyDeletedEvent((EntityProperty)property, (ApplicationUser)user);
    }

    public EntityPropertyType getEntityPropertyType() {
        return BoardPropertyService.BOARD_ENTITY_PROPERTY_TYPE;
    }

    private ErrorCollection permissionCheckToErrorCollection(boolean permissionCheckResult) {
        if (permissionCheckResult) {
            return new SimpleErrorCollection();
        }
        return new SimpleErrorCollection("gh.gadget.common.error.can.not.find.board.or.nopermission", ErrorCollection.Reason.NOT_FOUND);
    }
}

