/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.rapidview.BoardAdminManager;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardAdminServiceImpl
implements BoardAdminService {
    private final GroupManager groupManager;
    private final RapidViewPermissionService rapidViewPermissionService;
    private final BoardAdminManager boardAdminManager;

    @Autowired
    public BoardAdminServiceImpl(GroupManager groupManager, RapidViewPermissionService rapidViewPermissionService, BoardAdminManager boardAdminManager) {
        this.groupManager = groupManager;
        this.rapidViewPermissionService = rapidViewPermissionService;
        this.boardAdminManager = boardAdminManager;
    }

    @Override
    public List<BoardAdmin> getBoardAdmins(RapidView view) {
        return this.boardAdminManager.getBoardAdmins(view);
    }

    @Override
    public Multimap<RapidView, BoardAdmin> getBoardAdmins(List<RapidView> views) {
        return this.boardAdminManager.getBoardAdmins(views);
    }

    @Override
    @Nonnull
    public synchronized ServiceOutcome<List<BoardAdmin>> updateBoardAdmins(RapidView rapidView, ApplicationUser user, List<BoardAdmin> newBoardAdmins) {
        if (!this.rapidViewPermissionService.canEdit(user, rapidView)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.error.denied", new Object[0]);
        }
        return this.updateBoardAdminsWithList(rapidView, newBoardAdmins);
    }

    private synchronized ServiceOutcome<List<BoardAdmin>> updateBoardAdminsWithList(RapidView rapidView, List<BoardAdmin> newBoardAdmins) {
        if (newBoardAdmins == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.common.error.no.board.admin.key", new Object[0]);
        }
        if (newBoardAdmins.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.invalid.board.admins.empty", new Object[0]);
        }
        ServiceOutcome<List<BoardAdmin>> updatedBoardAdmins = this.boardAdminManager.updateBoardAdmin(rapidView, newBoardAdmins);
        if (updatedBoardAdmins.isInvalid()) {
            return ServiceOutcomeImpl.error(updatedBoardAdmins);
        }
        return ServiceOutcomeImpl.ok(updatedBoardAdmins.get());
    }

    @Override
    @Nonnull
    public boolean isUserBoardAdmin(RapidView rapidView, ApplicationUser user) {
        if (rapidView == null || user == null) {
            return false;
        }
        List<BoardAdmin> boardAdmins = this.getBoardAdmins(rapidView);
        for (BoardAdmin boardAdmin : boardAdmins) {
            if (boardAdmin.getType() == BoardAdmin.Type.USER && ApplicationUsers.getKeyFor((ApplicationUser)user).equals(boardAdmin.getKey())) {
                return true;
            }
            if (boardAdmin.getType() != BoardAdmin.Type.GROUP || !this.groupManager.isUserInGroup(user.getName(), boardAdmin.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ServiceOutcome<List<BoardAdmin>> setInitialBoardAdmin(RapidView rapidView, ApplicationUser user) {
        BoardAdmin newBoardAdmin = BoardAdmin.builder().key(ApplicationUsers.getKeyFor((ApplicationUser)user)).type(BoardAdmin.Type.USER).build();
        List<BoardAdmin> boardAdminsList = Collections.singletonList(newBoardAdmin);
        return this.updateBoardAdminsWithList(rapidView, boardAdminsList);
    }
}

