/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminAO;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminAOListMapper;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminAOMapper;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardAdminDao
extends GenericActiveObjectsDao<Long, BoardAdminAO>
implements RelatedEntityDao<Long, RapidViewAO, BoardAdminAO, BoardAdmin> {
    @Autowired
    private BoardAdminAOMapper boardAdminAOMapper;

    public BoardAdminAO[] getForParent(RapidViewAO parent) {
        return this.getForParent(parent.getId());
    }

    public BoardAdminAO[] getForParent(Long rapidViewId) {
        BoardAdminAO[] boardAdmins = (BoardAdminAO[])this.ao.find(BoardAdminAO.class, "RAPID_VIEW_ID = ?", new Object[]{rapidViewId});
        if (boardAdmins == null) {
            return new BoardAdminAO[0];
        }
        return boardAdmins;
    }

    @Override
    public List<BoardAdminAO> updateForParent(RapidViewAO parent, List<BoardAdmin> boardAdmins) {
        return AOUtil.setListValues(this.ao, new BoardAdminAOListMapper(parent, this.boardAdminAOMapper), boardAdmins);
    }

    public List<BoardAdminAO> appendBoardAdminForParent(RapidViewAO parent, List<BoardAdmin> boardAdmins) {
        return boardAdmins.stream().map(boardAdmin -> (BoardAdminAO)this.ao.create(BoardAdminAO.class, this.boardAdminAOMapper.toAO(parent, (BoardAdmin)boardAdmin))).collect(Collectors.toList());
    }

    @Override
    public void deleteForParent(RapidViewAO parent) {
        BoardAdminAO[] boardAdminAOs = this.getForParent(parent);
        this.delete(boardAdminAOs);
    }
}

