/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.AbstractModel;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.jira.config.FeatureManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BacklogColumnHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private ClusterLockService clusterLockService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private EventPublisher eventPublisher;

    public void addBacklogColumnIfNeededAndPerformCleanup(RapidView rapidView, List<Column> columns, BiFunction<RapidView, List<Column>, ServiceOutcome<List<Column>>> updateColumns, Function<RapidView, ImmutableList<Column>> getAllColumnsNoUpdate) {
        this.addBacklogColumnIfNeeded(rapidView, columns, updateColumns, getAllColumnsNoUpdate);
        this.cleanUpExcessBacklogColumns(rapidView, columns, updateColumns, getAllColumnsNoUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cleanUpExcessBacklogColumns(RapidView rapidView, List<Column> columns, BiFunction<RapidView, List<Column>, ServiceOutcome<List<Column>>> updateColumns, Function<RapidView, ImmutableList<Column>> getAllColumnsNoUpdate) {
        block9: {
            List<Column> backlogColumns = this.getKanbanBacklogColumns(columns);
            if (backlogColumns.size() > 1) {
                ClusterLock lock = this.clusterLockService.getLockForName(this.getLockName(rapidView));
                this.log.trace("Testing lock for cleaning up multiple backlog columns", new Object[0]);
                try {
                    if (!lock.tryLock(30L, TimeUnit.SECONDS)) break block9;
                    try {
                        if (this.getKanbanBacklogColumns((List)getAllColumnsNoUpdate.apply(rapidView)).size() <= 1) {
                            this.log.trace("Skipping removing excessive backlog columns, no excessive columns found", new Object[0]);
                            return;
                        }
                        List<String> backlogColumnStatuses = backlogColumns.stream().map(Column::getStatusIds).flatMap(Collection::stream).collect(Collectors.toList());
                        columns.removeAll(backlogColumns);
                        columns.add(0, KanbanBacklogColumn.from(new Column.ColumnBuilder(backlogColumns.get(0)).statusIds(backlogColumnStatuses).build()));
                        ServiceOutcome<List<Column>> updateColumnsToDbOutcome = updateColumns.apply(rapidView, columns);
                        if (updateColumnsToDbOutcome.isInvalid()) {
                            this.log.error("Can not remove excessive backlog columns from rapidView(%d): %s", rapidView.getId(), updateColumnsToDbOutcome.getErrors().toString());
                        }
                        this.eventPublisher.publish((Object)new KanplanExcessBacklogColumnCleanup());
                    }
                    finally {
                        this.log.trace("Unlocking lock for cleaning up multiple backlog columns", new Object[0]);
                        lock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private ServiceResult addBacklogColumnIfNeeded(RapidView rapidView, List<Column> columns, BiFunction<RapidView, List<Column>, ServiceOutcome<List<Column>>> updateColumns, Function<RapidView, ImmutableList<Column>> getAllColumnsNoUpdate) {
        if (!rapidView.isSprintSupportEnabled() && !this.getKanbanBacklogColumn(columns).isPresent() && this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN)) {
            ServiceResult addBacklogResult = this.addBacklogColumn(rapidView, columns, updateColumns, getAllColumnsNoUpdate);
            if (addBacklogResult.isInvalid()) {
                this.log.error("Can not add backlog column to rapidView", rapidView);
            }
            return addBacklogResult;
        }
        return ServiceResultImpl.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServiceResult addBacklogColumn(RapidView rapidView, List<Column> columns, BiFunction<RapidView, List<Column>, ServiceOutcome<List<Column>>> updateColumns, Function<RapidView, ImmutableList<Column>> getAllColumnsNoUpdate) {
        if (this.getKanbanBacklogColumn(columns).isPresent()) return ServiceResultImpl.ok();
        if (rapidView.getType() != RapidView.Type.KANBAN) {
            return ServiceResultImpl.ok();
        }
        ClusterLock lock = this.clusterLockService.getLockForName(this.getLockName(rapidView));
        this.log.trace("Testing lock for adding backlog column", new Object[0]);
        try {
            if (!lock.tryLock(30L, TimeUnit.SECONDS)) return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.boards.kanplan.error.add.backlog.column.retrytimeout", new Object[0]);
            try {
                ImmutableList<Column> freshColumns = getAllColumnsNoUpdate.apply(rapidView);
                if (this.getKanbanBacklogColumn((List<Column>)freshColumns).isPresent()) {
                    this.log.trace("Backlog column already present, skipping", new Object[0]);
                    columns.clear();
                    columns.addAll((Collection<Column>)freshColumns);
                    ServiceResult serviceResult = ServiceResultImpl.ok();
                    return serviceResult;
                }
                columns.add(0, KanbanBacklogColumn.emptyKanbanBacklogColumn());
                ServiceOutcome<List<Column>> updateColumnsToDbOutcome = updateColumns.apply(rapidView, columns);
                ServiceResult serviceResult = ServiceResultImpl.from(updateColumnsToDbOutcome.getErrors());
                return serviceResult;
            }
            finally {
                this.log.trace("Unlocking lock for adding backlog column", new Object[0]);
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.boards.kanplan.error.add.backlog.column.retrytimeout", new Object[0]);
    }

    public Optional<KanbanBacklogColumn> getKanbanBacklogColumn(List<Column> columns) {
        return columns.stream().filter(KanbanBacklogColumn::isKanbanBacklogColumn).map(KanbanBacklogColumn::from).findFirst();
    }

    private List<Column> getKanbanBacklogColumns(List<Column> columns) {
        return columns.stream().filter(KanbanBacklogColumn::isKanbanBacklogColumn).sorted(Comparator.comparing(AbstractModel::getId)).collect(Collectors.toList());
    }

    private String getLockName(@Nonnull RapidView rapidView) {
        Preconditions.checkNotNull((Object)rapidView);
        return BacklogColumnHelper.class.getName() + "-" + rapidView.getId();
    }

    @EventName(value="jira-software.kanplan.backlog.columns.fix")
    static class KanplanExcessBacklogColumnCleanup {
        KanplanExcessBacklogColumnCleanup() {
        }
    }
}

