/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.AOListMapper;
import com.atlassian.greenhopper.service.rapid.view.Entity;
import com.atlassian.greenhopper.service.rapid.view.Positionable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.java.ao.RawEntity;

public class AOUtil {
    private static PositionableComparator POS_COMPARATOR = new PositionableComparator();

    public static <T extends Entity, U> List<T> setListValues(ActiveObjects ao, AOListMapper<T, U> listMapper, List<U> newValues) {
        Entity[] existingValues = listMapper.getExisting();
        ArrayList<Entity> toRemove = new ArrayList<Entity>(Arrays.asList(existingValues));
        ArrayList<Entity> resultValues = new ArrayList<Entity>();
        int index = 0;
        for (U newValue : newValues) {
            Entity existingValue = listMapper.findExisting(existingValues, newValue);
            if (existingValue != null) {
                toRemove.remove(existingValue);
                listMapper.setValues(existingValue, newValue);
                if (existingValue instanceof Positionable) {
                    ((Positionable)((Object)existingValue)).setPos(index);
                }
                existingValue.save();
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                listMapper.addCreateValues(newValue, params);
                Class<T> aoClass = listMapper.getActiveObjectClass();
                if (Positionable.class.isAssignableFrom(aoClass)) {
                    params.put("POS", index);
                }
                existingValue = (Entity)ao.create(aoClass, params);
            }
            listMapper.postCreateUpdate(existingValue, newValue);
            resultValues.add(existingValue);
            ++index;
        }
        for (Entity t : toRemove) {
            listMapper.preDelete(t);
            ao.delete(new RawEntity[]{t});
        }
        return resultValues;
    }

    public static <T extends Positionable> void sortPositionableArray(T[] elements) {
        Arrays.sort(elements, POS_COMPARATOR);
    }

    public static <T extends Positionable> void sortPositionableList(List<T> list) {
        Collections.sort(list, POS_COMPARATOR);
    }

    static class PositionableComparator
    implements Comparator<Positionable> {
        PositionableComparator() {
        }

        @Override
        public int compare(Positionable arg0, Positionable arg1) {
            return arg0.getPos() - arg1.getPos();
        }
    }
}

