/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.jira.JiraServiceContextFactory;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.SavedFilterCreationRequestValidator;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.util.RequestBoundCacheFactory;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedFilterServiceImpl
implements SavedFilterService {
    private static final int MAX_FILTERS_DISPLAYED = Integer.MAX_VALUE;
    private static final String SAVED_FILTERS_CACHE_KEY = SavedFilterServiceImpl.class.getName() + ".savedFilters";
    @Autowired
    private SearchRequestService searchRequestService;
    @Autowired
    private SearchRequestManager searchRequestManager;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private JiraServiceContextFactory jiraServiceContextFactory;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RequestBoundCacheFactory requestBoundCacheFactory;
    @Autowired
    private SavedFilterCreationRequestValidator savedFilterCreationRequestValidator;

    @Override
    @Nonnull
    public ServiceOutcome<List<SearchRequest>> getSavedFiltersForUser(ApplicationUser user) {
        TreeSet filters = new TreeSet(new NullComparator((Comparator)new Comparator<SearchRequest>(){

            @Override
            public int compare(SearchRequest arg0, SearchRequest arg1) {
                if (arg0.getName() == null && arg1.getName() == null) {
                    return 0;
                }
                if (arg0.getName() == null || arg1.getName() == null) {
                    return arg0.getName() == null ? -1 : 1;
                }
                return arg0.getName().compareToIgnoreCase(arg1.getName());
            }
        }, false));
        if (user != null) {
            filters.addAll(this.searchRequestService.getFavouriteFilters(user));
            filters.addAll(this.searchRequestService.getOwnedFilters(user));
        }
        JiraServiceContextImpl serviceCtx = new JiraServiceContextImpl(user);
        SharedEntitySearchParameters parameters = new SharedEntitySearchParametersBuilder().toSearchParameters();
        SharedEntitySearchResult results = this.searchRequestService.search((JiraServiceContext)serviceCtx, parameters, 0, Integer.MAX_VALUE);
        filters.addAll(results.getResults());
        ArrayList result = new ArrayList(filters);
        return ServiceOutcomeImpl.ok(result);
    }

    @Override
    public ServiceOutcome<List<SearchRequest>> findSavedFilters(ApplicationUser user, String query) {
        query = this.formatQuery(query);
        SharedEntitySearchParameters searchParameters = new SharedEntitySearchParametersBuilder().setTextSearchMode(SharedEntitySearchParameters.TextSearchMode.WILDCARD).setName(query).setSortColumn(SharedEntityColumn.NAME, true).toSearchParameters();
        JiraServiceContext ctx = this.jiraServiceContextFactory.buildUserContext(user);
        com.atlassian.jira.util.ErrorCollection jiraErrors = ctx.getErrorCollection();
        SharedEntitySearchAction.QueryValidator.validate((SharedEntitySearchParameters)searchParameters, (com.atlassian.jira.util.ErrorCollection)jiraErrors, (I18nHelper)ctx.getI18nBean());
        if (jiraErrors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(jiraErrors);
        }
        SharedEntitySearchResult result = this.searchRequestService.search(ctx, searchParameters, 0, 20);
        if (jiraErrors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(jiraErrors);
        }
        return ServiceOutcomeImpl.ok(result.getResults());
    }

    private String formatQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            query = "";
        } else {
            StringBuilder sb = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(query, "-_/\\,+=&^%$#*@!~`'\":;<> ");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (StringUtils.isBlank((CharSequence)token)) continue;
                sb.append("+").append(token).append(" ");
            }
            query = sb.toString().trim();
        }
        return query;
    }

    @Override
    @Nonnull
    public ServiceOutcome<SearchRequest> getSavedFilter(ApplicationUser user, Long id) {
        SavedFilterKey cacheKey = new SavedFilterKey(user, id);
        Map cache = this.requestBoundCacheFactory.getCache(SAVED_FILTERS_CACHE_KEY);
        ServiceOutcome<Object> filterOutcome = (ServiceOutcome<SearchRequest>)cache.get(cacheKey);
        if (filterOutcome == null) {
            JiraServiceContextImpl serviceCtx = new JiraServiceContextImpl(user);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceCtx, id);
            filterOutcome = serviceCtx.getErrorCollection().hasAnyErrors() ? ServiceOutcomeImpl.from(serviceCtx.getErrorCollection()) : ServiceOutcomeImpl.ok(filter);
            cache.put(cacheKey, filterOutcome);
        }
        return filterOutcome;
    }

    @Override
    public ServiceOutcome<SearchRequest> createSavedFilterWithNoPermissionCheck(ApplicationUser user, String boardName, Query query, SharedEntity.SharePermissions permissions) {
        ServiceOutcome<SearchRequest> searchRequest = this.createSearchRequest(user, boardName, query, permissions);
        if (searchRequest.isInvalid()) {
            return ServiceOutcomeImpl.from(searchRequest.getErrors());
        }
        ServiceResult serviceResult = this.savedFilterCreationRequestValidator.validate(searchRequest.getValue());
        ServiceOutcome<SearchRequest> searchRequestOutcome = serviceResult.isValid() ? ServiceOutcomeImpl.ok(this.searchRequestManager.create(searchRequest.getValue())) : ServiceOutcomeImpl.from(serviceResult.getErrors());
        return searchRequestOutcome;
    }

    @Override
    public ServiceOutcome<SearchRequest> createSavedFilter(ApplicationUser user, String boardName, Query query, SharedEntity.SharePermissions permissions) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        ServiceOutcome<SearchRequest> searchRequest = this.createSearchRequest(user, boardName, query, permissions);
        if (searchRequest.isInvalid()) {
            return ServiceOutcomeImpl.from(searchRequest.getErrors());
        }
        this.searchRequestService.validateFilterForCreate((JiraServiceContext)serviceContext, searchRequest.getValue());
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(serviceContext.getErrorCollection());
        }
        SearchRequest result = this.searchRequestService.createFilter((JiraServiceContext)serviceContext, searchRequest.getValue());
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(serviceContext.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(result);
    }

    private ServiceOutcome<SearchRequest> createSearchRequest(ApplicationUser user, String boardName, Query query, SharedEntity.SharePermissions permissions) {
        ServiceOutcome<String> availableFilterName = this.findAvailableFilterName(user, boardName);
        if (availableFilterName.isInvalid()) {
            return ServiceOutcomeImpl.from(availableFilterName.getErrors());
        }
        SearchRequest savedFilter = new SearchRequest(query, user.getName(), availableFilterName.getValue(), null);
        savedFilter.setPermissions(permissions);
        return ServiceOutcomeImpl.ok(savedFilter);
    }

    @Override
    public ServiceOutcome<Void> deleteSavedFilter(ApplicationUser user, Long id) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        this.searchRequestService.validateForDelete((JiraServiceContext)serviceContext, id);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(serviceContext.getErrorCollection());
        }
        this.searchRequestService.deleteFilter((JiraServiceContext)serviceContext, id);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(serviceContext.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<String> findAvailableFilterName(ApplicationUser user, String boardName) {
        String lastFilterName;
        int i = 0;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        String newFilterName = "";
        do {
            SearchRequest existingFilter;
            lastFilterName = newFilterName;
            if ((existingFilter = this.searchRequestManager.getOwnedSearchRequestByName(user, newFilterName = i18n.getText("gh.rapid.view.copy.filter.format", (Object)boardName, (Object)(++i)))) != null) continue;
            return ServiceOutcomeImpl.ok(newFilterName);
        } while (!lastFilterName.equals(newFilterName));
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.finding.available.filter", new Object[0]);
    }

    @Override
    public SearchRequest updateSavedFilter(ApplicationUser user, ErrorCollection errors, SearchRequest savedFilter) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        this.searchRequestService.validateFilterForUpdate((JiraServiceContext)serviceContext, savedFilter);
        errors.addAllErrors(ErrorCollection.fromJiraErrorCollection(serviceContext.getErrorCollection()));
        return errors.hasErrors() ? null : this.searchRequestService.updateFilter((JiraServiceContext)serviceContext, savedFilter);
    }

    @Override
    public ServiceOutcome<SearchRequest> setOrderByRank(ApplicationUser user, SearchRequest savedFilter) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)savedFilter.getQuery());
        JqlOrderByBuilder orderBy = queryBuilder.orderBy();
        CustomField rankField = this.rankCustomFieldService.getDefaultRankField();
        ServiceOutcome<Void> validity = this.rankCustomFieldService.validateRankFieldConfiguration(user, rankField);
        if (validity.isInvalid()) {
            return ServiceOutcomeImpl.error(validity);
        }
        ServiceOutcome<Boolean> canUseName = this.rankCustomFieldService.isFieldNameInQuerySafe(rankField);
        if (canUseName.isInvalid()) {
            return ServiceOutcomeImpl.error(canUseName);
        }
        if (canUseName.getValue().booleanValue()) {
            orderBy.clear().addSortForFieldName(rankField.getName(), SortOrder.ASC, true);
        } else {
            String jqlId = JqlCustomFieldId.toString((long)rankField.getIdAsLong());
            orderBy.clear().addSortForFieldName(jqlId, SortOrder.ASC, true);
        }
        Query newQuery = queryBuilder.buildQuery();
        savedFilter.setQuery(newQuery);
        ErrorCollection errors = new ErrorCollection();
        SearchRequest request = this.updateSavedFilter(user, errors, savedFilter);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok(savedFilter);
    }

    @Override
    public boolean canUserSeeAnySavedFilters(ApplicationUser user) {
        JiraServiceContextImpl serviceCtx = new JiraServiceContextImpl(user);
        SharedEntitySearchParameters parameters = new SharedEntitySearchParametersBuilder().toSearchParameters();
        SharedEntitySearchResult results = this.searchRequestService.search((JiraServiceContext)serviceCtx, parameters, 0, 1);
        return !results.isEmpty();
    }

    protected static class SavedFilterKey {
        private final String userName;
        private final Long filterId;
        private final int hash;

        public SavedFilterKey(@Nullable ApplicationUser user, @Nonnull Long filterId) {
            this.userName = user != null ? user.getName() : null;
            this.filterId = filterId;
            this.hash = (this.userName != null ? 31 * this.userName.hashCode() : 0) + filterId.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SavedFilterKey)) {
                return false;
            }
            SavedFilterKey that = (SavedFilterKey)o;
            if (!this.filterId.equals(that.filterId)) {
                return false;
            }
            return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
        }
    }
}

