/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedFilterCreationRequestValidator {
    @VisibleForTesting
    static final String ERROR_MESSAGE_KEY_USER_MUST_BE_AN_ADMIN = "gh.rapid.view.filter.creation.error.user.not.admin";
    @VisibleForTesting
    static final String ERROR_MESSAGE_KEY_FILTER_MUST_BE_OWNED_BY_CURRENT_USER = "gh.rapid.view.filter.creation.error.user.must.be.owner";
    @VisibleForTesting
    static final String ERROR_MESSAGE_KEY_FILTER_NAME_MUST_BE_SPECIFIED = "gh.rapid.view.filter.creation.error.name.not.specified";
    @VisibleForTesting
    static final String ERROR_MESSAGE_KEY_FILTER_NAME_TOO_LONG = "gh.rapid.view.filter.creation.error.name.too.long";
    private static final int MAX_FILTER_NAME_LENGTH = 255;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public SavedFilterCreationRequestValidator(GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public ServiceResult validate(SearchRequest searchRequest) {
        ErrorCollection errorCollection = new ErrorCollection();
        this.validateCurrentUserIsAnAdmin(errorCollection);
        this.validateFilterIsOwnedByCurrentUser(searchRequest, errorCollection);
        this.validateFilterName(searchRequest, errorCollection);
        return ServiceResultImpl.from(errorCollection);
    }

    private void validateCurrentUserIsAnAdmin(ErrorCollection errorCollection) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.jiraAuthenticationContext.getUser())) {
            errorCollection.addError(ERROR_MESSAGE_KEY_USER_MUST_BE_AN_ADMIN, new Object[0]);
        }
    }

    private void validateFilterIsOwnedByCurrentUser(SearchRequest searchRequest, ErrorCollection errorCollection) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        if (currentUser != null && !currentUser.equals((Object)searchRequest.getOwner())) {
            errorCollection.addError(ERROR_MESSAGE_KEY_FILTER_MUST_BE_OWNED_BY_CURRENT_USER, new Object[0]);
        }
    }

    private void validateFilterName(SearchRequest searchRequest, ErrorCollection errorCollection) {
        String filterName = searchRequest.getName();
        if (StringUtils.isBlank((CharSequence)filterName)) {
            errorCollection.addError(ERROR_MESSAGE_KEY_FILTER_NAME_MUST_BE_SPECIFIED, new Object[0]);
        } else if (filterName.trim().length() > 255) {
            errorCollection.addError(ERROR_MESSAGE_KEY_FILTER_NAME_TOO_LONG, new Object[0]);
        }
    }
}

