/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.RecentSprintHistoryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecentSprintHistoryServiceImpl
implements RecentSprintHistoryService {
    private static final UserHistoryItem.Type sprintHistoryType = new UserHistoryItem.Type("Sprint");
    @Autowired
    private UserHistoryManager userHistoryManager;
    @Autowired
    private SprintService sprintService;

    @Override
    public void storeSprint(@Nullable ApplicationUser user, Sprint sprint) {
        if (sprint != null && sprint.getId() != null) {
            this.userHistoryManager.addItemToHistory(sprintHistoryType, user, sprint.getId().toString(), sprint.getName());
        }
    }

    @Override
    @Nonnull
    public List<Sprint> getRecentSprints(@Nullable ApplicationUser user, int count) {
        Predicate predicate = Predicates.alwaysTrue();
        return this.getRecentSprintsMatchingPredicate(user, (Predicate<Sprint>)predicate, count);
    }

    @Override
    @Nonnull
    public List<Sprint> getRecentSprintsMatchingPredicate(@Nullable ApplicationUser user, Predicate<Sprint> predicate, int count) {
        ArrayList results = Lists.newArrayList();
        List userHistoryItems = this.userHistoryManager.getHistory(sprintHistoryType, user);
        for (UserHistoryItem item : userHistoryItems) {
            Long sprintId;
            String sprintIdAsString = item.getEntityId();
            try {
                sprintId = NumberUtils.toLong(sprintIdAsString);
            }
            catch (NumberFormatException e) {
                continue;
            }
            ServiceOutcome<Sprint> sprint = this.sprintService.getSprint(user, sprintId);
            if (!sprint.isValid() || !predicate.apply((Object)sprint.getValue())) continue;
            results.add(sprint.getValue());
            if (count < 1 || results.size() < count) continue;
            break;
        }
        return results;
    }
}

