/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.query.QueryOptimizationService;
import com.atlassian.greenhopper.service.rapid.EmptyFilterQueryWrapper;
import com.atlassian.greenhopper.service.rapid.EmptyQueryAwareJqlBuilder;
import com.atlassian.greenhopper.service.rapid.RapidViewClauseService;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.KanbanBacklogColumnService;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import io.atlassian.fugue.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidViewQueryServiceImpl
implements RapidViewQueryService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private RapidViewClauseService rapidViewClauseService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private QuickFilterService quickFilterService;
    @Autowired
    private JqlQueryParser jqlQueryParser;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private SprintService sprintService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private QueryOptimizationService queryOptimizationService;
    @Autowired
    private RapidViewColumnService rapidViewColumnService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private KanbanBacklogColumnService kanbanBacklogColumnService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Override
    @Nonnull
    public ServiceOutcome<Query> getRapidViewQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        Query savedFilterQuery = savedFilter.get().getQuery();
        Query optimizedQuery = this.queryOptimizationService.optimizeQuery(savedFilterQuery);
        return ServiceOutcomeImpl.ok(this.shouldQueryReturnNoResults(savedFilterQuery) ? new EmptyFilterQueryWrapper(savedFilterQuery) : optimizedQuery);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Clause> getStatusMappingClause(ApplicationUser user, RapidView rapidView) {
        Set<Status> mappedStatuses = this.columnService.getMappedStatuses(rapidView);
        if (mappedStatuses.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.board.error.nostatusmapped", new Object[0]);
        }
        List<String> statusIds = mappedStatuses.stream().map(IssueConstant::getId).collect(Collectors.toList());
        Clause statusIdsClause = JqlQueryBuilder.newClauseBuilder().status().in(statusIds.toArray(new String[statusIds.size()])).buildClause();
        return ServiceOutcomeImpl.ok(statusIdsClause);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getMappedRapidViewQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.getRapidViewQuery(user, rapidView);
        if (rapidViewQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        ServiceOutcome<Clause> statusMappingClause = this.getStatusMappingClause(user, rapidView);
        if (statusMappingClause.isInvalid()) {
            return ServiceOutcomeImpl.error(statusMappingClause);
        }
        EmptyQueryAwareJqlBuilder queryBuilder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery.get());
        queryBuilder.where().defaultAnd().addClause(statusMappingClause.getValue());
        return ServiceOutcomeImpl.ok(queryBuilder.buildQuery());
    }

    private boolean shouldQueryReturnNoResults(Query query) {
        return this.disableEmptyJqlQueries() && query.getWhereClause() == null && (query.getOrderByClause() == null || query.getOrderByClause().getSearchSorts().isEmpty());
    }

    private boolean disableEmptyJqlQueries() {
        return this.applicationProperties.getOption("jira.empty.jql.returns.no.data.enabled");
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getWorkModeQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return rapidViewQuery;
        }
        EmptyQueryAwareJqlBuilder builder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery.getValue());
        ServiceOutcome<ClauseToAdd> clauseForBuilder = this.rapidViewClauseService.getWorkModeClause(user, rapidView);
        if (!clauseForBuilder.isValid()) {
            return ServiceOutcomeImpl.error(clauseForBuilder);
        }
        builder = clauseForBuilder.get().appendWithDefaultAnd(builder);
        return ServiceOutcomeImpl.ok(builder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getWorkModeQuery(ApplicationUser user, RapidView rapidView, Column column) {
        ServiceOutcome<Query> rapidViewQuery = this.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return rapidViewQuery;
        }
        EmptyQueryAwareJqlBuilder builder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery.getValue());
        ServiceOutcome<ClauseToAdd> clauseForBuilder = this.rapidViewClauseService.getWorkModeClause(user, rapidView);
        if (!clauseForBuilder.isValid()) {
            return ServiceOutcomeImpl.error(clauseForBuilder);
        }
        builder = clauseForBuilder.get().appendWithDefaultAnd(builder);
        builder.where().defaultAnd().status(column.getStatusIds().toArray(new String[column.getStatusIds().size()]));
        return ServiceOutcomeImpl.ok(builder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getBacklogQuery(ApplicationUser user, RapidView rapidView) {
        return this.getBacklogQuery(user, rapidView, false);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getBacklogQuery(ApplicationUser user, RapidView rapidView, boolean withSubtasks) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return rapidViewQuery;
        }
        EmptyQueryAwareJqlBuilder rapidViewQueryBuilder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery.getValue());
        ServiceOutcome<ClauseToAdd> subTasksClause = withSubtasks ? this.rapidViewClauseService.getPlanModeWithSubtasksClause(user, rapidView) : this.rapidViewClauseService.getPlanModeClause(user, rapidView);
        if (!subTasksClause.isValid()) {
            return ServiceOutcomeImpl.from(subTasksClause.getErrors());
        }
        if (subTasksClause.get().hasClause()) {
            subTasksClause.get().appendWithDefaultAnd(rapidViewQueryBuilder);
        }
        return ServiceOutcomeImpl.ok(rapidViewQueryBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getActiveSprintsForPlanModeQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return rapidViewQuery;
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue());
        ServiceOutcome<ClauseToAdd> subquery = this.rapidViewClauseService.getPlanModeActiveSprintsClause(rapidView);
        if (!subquery.isValid()) {
            return ServiceOutcomeImpl.from(subquery.getErrors());
        }
        if (subquery.get().hasClause()) {
            subquery.get().appendWithDefaultAnd(builder);
        }
        return ServiceOutcomeImpl.ok(builder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getPlanModeIssuesQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return rapidViewQuery;
        }
        EmptyQueryAwareJqlBuilder rapidViewQueryBuilder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery.getValue());
        ServiceOutcome<ClauseToAdd> planModeIssuesClause = this.rapidViewClauseService.getPlanModeIssuesClause(user, rapidView);
        if (!planModeIssuesClause.isValid()) {
            return ServiceOutcomeImpl.from(planModeIssuesClause.getErrors());
        }
        planModeIssuesClause.get().appendWithDefaultAnd(rapidViewQueryBuilder);
        return ServiceOutcomeImpl.ok(rapidViewQueryBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getOpenSprintsQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return rapidViewQuery;
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue());
        Clause inOpenSprintClause = this.sprintQueryService.getInOpenSprintClause();
        builder.where().defaultAnd().addClause(inOpenSprintClause);
        return ServiceOutcomeImpl.ok(builder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getOpenSprintQuery(ApplicationUser user, RapidView rapidView, Long sprintId) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (rapidViewQuery.isInvalid()) {
            return rapidViewQuery;
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue());
        ServiceOutcome<Sprint> sprintOutcome = this.sprintService.getSprint(user, sprintId);
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintOutcome);
        }
        Clause inSprintClause = this.sprintQueryService.getSprintClause(sprintOutcome.getValue());
        builder.where().defaultAnd().addClause(inSprintClause);
        return ServiceOutcomeImpl.ok(builder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Pair<List<Sprint>, Set<Long>>> getOpenSprintsAndBacklogProjects(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> sprintQuery = this.getOpenSprintsQuery(user, rapidView);
        if (!sprintQuery.isValid()) {
            return ServiceOutcomeImpl.error(sprintQuery);
        }
        return this.sprintQueryService.getOpenSprintsAndBacklogProjects(user, sprintQuery.getValue());
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getQuickFilterClause(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilterIds) {
        boolean hasFiltersActive;
        boolean bl = hasFiltersActive = activeQuickFilterIds != null && !activeQuickFilterIds.isEmpty();
        if (hasFiltersActive) {
            List<QuickFilter> quickFilters = this.quickFilterService.loadQuickFilters(rapidView);
            return this.buildQuickFilterClause(quickFilters, activeQuickFilterIds, user);
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getSprintFilterClause(ApplicationUser user, RapidView rapidView, Set<Long> activeSprintIds) {
        boolean hasSprints;
        boolean bl = hasSprints = activeSprintIds != null && !activeSprintIds.isEmpty();
        if (!hasSprints) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        ServiceOutcome<Set<Sprint>> sprints = this.sprintService.getSprints(user, rapidView, activeSprintIds);
        if (!sprints.isValid()) {
            return ServiceOutcomeImpl.error(sprints);
        }
        Clause clause = this.sprintQueryService.getSprintsClause((Collection<Sprint>)sprints.getValue());
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(clause));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getScrumBoardQueryForVisibleIssues(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> outcome = this.getRapidViewQuery(user, rapidView);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        Query rapidViewQuery = outcome.getValue();
        EmptyQueryAwareJqlBuilder queryBuilder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery);
        JqlQueryBuilder extraClauses = JqlQueryBuilder.newBuilder();
        ServiceOutcome<ClauseToAdd> planClause = this.rapidViewClauseService.getPlanModeClause(user, rapidView);
        if (!planClause.isValid()) {
            return ServiceOutcomeImpl.error(planClause);
        }
        ServiceOutcome<ClauseToAdd> workClause = this.rapidViewClauseService.getWorkModeClause(user, rapidView);
        if (!workClause.isValid()) {
            return ServiceOutcomeImpl.error(workClause);
        }
        ServiceOutcome<ClauseToAdd> reportClause = this.rapidViewClauseService.getSprintReportModeClause(user, rapidView);
        if (!reportClause.isValid()) {
            return ServiceOutcomeImpl.error(reportClause);
        }
        ServiceOutcome<ClauseToAdd> epicClause = this.rapidViewClauseService.getVisibleEpicsClause(user, rapidView);
        if (!epicClause.isValid()) {
            return ServiceOutcomeImpl.error(epicClause);
        }
        extraClauses = planClause.get().appendWithDefaultOr(extraClauses);
        extraClauses = workClause.get().appendWithDefaultOr(extraClauses);
        extraClauses = reportClause.get().appendWithDefaultOr(extraClauses);
        extraClauses = epicClause.get().appendWithDefaultOr(extraClauses);
        Query result = queryBuilder.where().defaultAnd().sub().addClause(extraClauses.buildQuery().getWhereClause()).endsub().buildQuery();
        return ServiceOutcomeImpl.ok(result);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getFullRapidViewQuery(@Nullable ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(rapidViewQuery.get());
        }
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        EmptyQueryAwareJqlBuilder jqlBuilder = EmptyQueryAwareJqlBuilder.newBuilder(rapidViewQuery.get());
        jqlBuilder.where().defaultAnd().issueType().notEq(epicIssues.getId());
        return ServiceOutcomeImpl.ok(jqlBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getRapidViewBacklogQuery(@Nullable ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<List<String>> statusIdList = this.rapidViewColumnService.getDoneStatusIds(user, rapidView);
        if (!statusIdList.isValid()) {
            return ServiceOutcomeImpl.error(statusIdList);
        }
        String[] statusIds = statusIdList.get().toArray(new String[statusIdList.get().size()]);
        Clause notDoneClause = JqlQueryBuilder.newClauseBuilder().defaultAnd().status().notIn(statusIds).buildClause();
        ServiceOutcome<Query> boardQuery = this.getFullRapidViewQuery(user, rapidView);
        if (!boardQuery.isValid()) {
            return ServiceOutcomeImpl.error(boardQuery);
        }
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        Clause sprintIsEmpty = JqlQueryBuilder.newClauseBuilder().defaultAnd().customField(defaultSprintField.getIdAsLong()).isEmpty().buildClause();
        Clause sprintIsNotFutureAndActive = JqlQueryBuilder.newClauseBuilder().defaultAnd().sub().customField(defaultSprintField.getIdAsLong()).notIn().function("futureSprints").defaultAnd().customField(defaultSprintField.getIdAsLong()).notIn().function("openSprints").endsub().buildClause();
        Clause sprintIsEmptyOrIsNotFutureAndActive = JqlQueryBuilder.newClauseBuilder().defaultAnd().sub().addClause(sprintIsEmpty).or().addClause(sprintIsNotFutureAndActive).endsub().buildClause();
        EmptyQueryAwareJqlBuilder jqlBuilder = EmptyQueryAwareJqlBuilder.newBuilder(boardQuery.get());
        jqlBuilder.where().defaultAnd().addClause(notDoneClause).defaultAnd().addClause(sprintIsEmptyOrIsNotFutureAndActive);
        return ServiceOutcomeImpl.ok(jqlBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getSprintQuery(@Nullable ApplicationUser user, Sprint sprint) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder().where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).endWhere().orderBy().setSorts(this.getRankOrder()).endOrderBy();
        return ServiceOutcomeImpl.ok(jqlQueryBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getSprintQueryInBoardContext(@Nullable ApplicationUser user, RapidView rapidView, Sprint sprint) {
        ServiceOutcome<Query> boardQuery = this.getFullRapidViewQuery(user, rapidView);
        if (!boardQuery.isValid()) {
            return ServiceOutcomeImpl.error(boardQuery);
        }
        EmptyQueryAwareJqlBuilder jqlBuilder = EmptyQueryAwareJqlBuilder.newBuilder(boardQuery.get());
        jqlBuilder.where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).endWhere();
        return ServiceOutcomeImpl.ok(jqlBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getEpicQuery(@Nullable ApplicationUser user, Epic epic) {
        CustomField defaultEpicField = this.epicCustomFieldService.getDefaultEpicLinkField();
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder().where().defaultAnd().customField(defaultEpicField.getIdAsLong()).eq(epic.getId()).endWhere().orderBy().setSorts(this.getRankOrder()).endOrderBy();
        return ServiceOutcomeImpl.ok(jqlQueryBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getEpicQueryInBoardContext(@Nullable ApplicationUser user, RapidView rapidView, Epic epic) {
        ServiceOutcome<Query> boardQuery = this.getFullRapidViewQuery(user, rapidView);
        if (!boardQuery.isValid()) {
            return ServiceOutcomeImpl.error(boardQuery);
        }
        CustomField defaultEpicField = this.epicCustomFieldService.getDefaultEpicLinkField();
        Query query = JqlQueryBuilder.newBuilder((Query)boardQuery.get()).where().defaultAnd().customField(defaultEpicField.getIdAsLong()).eq(epic.getId()).endWhere().buildQuery();
        return ServiceOutcomeImpl.ok(query);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getIssuesWithoutEpicQuery(@Nullable ApplicationUser user) {
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        CustomField defaultEpicField = this.epicCustomFieldService.getDefaultEpicLinkField();
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder().where().defaultAnd().customField(defaultEpicField.getIdAsLong()).isEmpty().defaultAnd().issueType().notEq(epicIssues.getId()).endWhere().orderBy().setSorts(this.getRankOrder()).endOrderBy();
        return ServiceOutcomeImpl.ok(jqlQueryBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Query> getIssuesWithoutEpicQueryInBoardContext(@Nullable ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> boardQuery = this.getFullRapidViewQuery(user, rapidView);
        if (!boardQuery.isValid()) {
            return ServiceOutcomeImpl.error(boardQuery);
        }
        CustomField defaultEpicField = this.epicCustomFieldService.getDefaultEpicLinkField();
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)boardQuery.get()).where().defaultAnd().customField(defaultEpicField.getIdAsLong()).isEmpty().endWhere();
        return ServiceOutcomeImpl.ok(jqlQueryBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public Query joinQueries(Query queryA, @Nullable Query queryB) {
        if (queryB == null) {
            return queryA;
        }
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)queryB);
        if (queryA.getWhereClause() != null) {
            jqlQueryBuilder = jqlQueryBuilder.where().defaultAnd().addClause(queryA.getWhereClause()).endWhere();
        }
        if (queryA.getOrderByClause() != null) {
            JqlOrderByBuilder jqlOrderByBuilder = jqlQueryBuilder.orderBy();
            for (SearchSort searchSort : queryA.getOrderByClause().getSearchSorts()) {
                jqlOrderByBuilder.add(searchSort.getField(), searchSort.getSortOrder());
            }
            jqlQueryBuilder = jqlOrderByBuilder.endOrderBy();
        }
        return jqlQueryBuilder.buildQuery();
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getKanbanBacklogFilterClause(ApplicationUser user, RapidView rapidView) {
        if (this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN) && this.columnService.isKanPlanEnabledForBoard(rapidView)) {
            ServiceOutcome<KanbanBacklogColumn> backlogColumnOutcome = this.columnService.getKanbanBacklogColumn(rapidView);
            if (!backlogColumnOutcome.isValid()) {
                return ServiceOutcomeImpl.error(backlogColumnOutcome);
            }
            KanbanBacklogColumn backlogColumn = backlogColumnOutcome.get();
            if (backlogColumn.isKanbanBacklogMapped()) {
                List<String> statusIds = backlogColumn.getStatusIds();
                Clause clause = JqlQueryBuilder.newClauseBuilder().not().status().in(statusIds.toArray(new String[statusIds.size()])).buildClause();
                return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(clause));
            }
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getKanbanDoneColumnFilterClause(ApplicationUser user, RapidView rapidView) {
        if (this.featureManager.isEnabled(SoftwareFeatureFlags.KANBAN_HIDE_OLD_DONE_ISSUES) && rapidView.isOldDoneIssuesCutoffSpecified()) {
            Clause clause = JqlQueryBuilder.newClauseBuilder().updatedAfter(rapidView.getOldDoneIssuesCutoff().getValue()).or().statusCategory().notEq("Done").buildClause();
            return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(clause));
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
    }

    @Nullable
    private OrderBy getRankOrder() {
        CustomField defaultRankField = this.lexoRankCustomFieldService.getDefaultRankField();
        String primaryClauseName = defaultRankField.getClauseNames().getPrimaryName();
        return JqlQueryBuilder.newOrderByBuilder().add(primaryClauseName, SortOrder.ASC).buildOrderBy();
    }

    private ServiceOutcome<ClauseToAdd> buildQuickFilterClause(List<QuickFilter> quickFilters, Set<Long> activeQuickFilters, ApplicationUser user) {
        JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newClauseBuilder();
        for (QuickFilter quickFilter : quickFilters) {
            Clause clause;
            if (!activeQuickFilters.contains(quickFilter.getId())) continue;
            try {
                clause = this.jqlQueryParser.parseQuery(quickFilter.getQuery()).getWhereClause();
            }
            catch (JqlParseException e) {
                I18n2 i18n = this.i18nFactoryService.getI18n(user);
                this.log.warn("Unable to parse quickFilter query, quickFilter=%s, query:%s", i18n.getText(quickFilter.getName()), quickFilter.getQuery());
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.quickfilter.invalid.configuration", i18n.getText(quickFilter.getName()));
            }
            if (clause == null) continue;
            clauseBuilder.defaultAnd().sub().addClause(clause).endsub();
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(clauseBuilder.buildClause()));
    }
}

