/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.callback.ProjectIssueDataCallback;
import com.atlassian.greenhopper.service.query.QueryOptimizationService;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.BoardLocation;
import com.atlassian.greenhopper.service.rapid.RapidViewClauseService;
import com.atlassian.greenhopper.service.rapid.RapidViewLocationService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewLocationServiceImpl
implements RapidViewLocationService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private RapidViewClauseService rapidViewClauseService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private QueryService queryService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private QueryOptimizationService queryOptimizationService;
    @Autowired
    private ColumnService columnService;

    @Override
    @Nonnull
    public ServiceOutcome<Set<RapidView>> getRapidViewsForIssue(ApplicationUser user, Issue issue) {
        if (!this.permissionService.hasPermission(user, issue, 10)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "admin.errors.issues.no.browse.permission", new Object[0]);
        }
        Long projectId = issue.getProjectObject().getId();
        ServiceOutcome<List<RapidView>> rapidViews = this.rapidViewService.getRapidViews(user);
        if (!rapidViews.isValid()) {
            return ServiceOutcomeImpl.error(rapidViews);
        }
        HashSet boardsForThisIssue = Sets.newHashSet();
        HashMap projectsForBoard = Maps.newHashMap();
        HashMultimap queriesForBoard = HashMultimap.create();
        HashMultimap issuesAndQueries = HashMultimap.create();
        for (RapidView rapidView : rapidViews.getValue()) {
            Query rapidViewQuery;
            ServiceOutcome<Query> outcome;
            Issue currentIssue = issue;
            if (!rapidView.isSprintSupportEnabled()) {
                outcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
                if (!outcome.isValid()) {
                    this.logWarningUnableToRetrieveQuery(rapidView, outcome);
                    continue;
                }
                rapidViewQuery = outcome.getValue();
            } else {
                outcome = this.rapidViewQueryService.getScrumBoardQueryForVisibleIssues(user, rapidView);
                if (!outcome.isValid()) {
                    this.logWarningUnableToRetrieveQuery(rapidView, outcome);
                    continue;
                }
                rapidViewQuery = outcome.getValue();
                if (issue.isSubTask()) {
                    currentIssue = issue.getParentObject();
                }
            }
            if (this.queryService.isProjectClauseOnlyQuery(rapidViewQuery)) {
                projectsForBoard.put(rapidView, this.calculateProjectsInRapidView(user, rapidViewQuery));
                continue;
            }
            queriesForBoard.put((Object)rapidViewQuery, (Object)rapidView);
            issuesAndQueries.put((Object)currentIssue, (Object)rapidViewQuery);
        }
        if (!queriesForBoard.isEmpty()) {
            ServiceOutcome<Set<Query>> outcome = this.findQueriesMatchingIssue(user, issuesAndQueries.asMap());
            if (outcome.isInvalid()) {
                return ServiceOutcomeImpl.error(outcome);
            }
            for (Query rapidViewQuery : outcome.getValue()) {
                boardsForThisIssue.addAll(queriesForBoard.get((Object)rapidViewQuery));
            }
        }
        if (!projectsForBoard.isEmpty()) {
            for (Map.Entry entry : projectsForBoard.entrySet()) {
                if (!((Set)entry.getValue()).contains(projectId)) continue;
                boardsForThisIssue.add(entry.getKey());
            }
        }
        return ServiceOutcomeImpl.ok(boardsForThisIssue);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Set<RapidView>> getRapidViewsForSprint(ApplicationUser user, Long sprintId) {
        ServiceOutcome<List<RapidView>> rapidViews = this.rapidViewService.getRapidViews(user);
        if (!rapidViews.isValid()) {
            return ServiceOutcomeImpl.error(rapidViews);
        }
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        HashSet<RapidView> boardsForThisSprint = new HashSet<RapidView>();
        HashMap<RapidView, Set<Long>> projectsForBoard = new HashMap<RapidView, Set<Long>>();
        for (RapidView rapidView : rapidViews.getValue()) {
            if (!rapidView.isSprintSupportEnabled()) continue;
            ServiceOutcome<Query> outcome = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
            if (!outcome.isValid()) {
                this.logWarningUnableToRetrieveQuery(rapidView, outcome);
                continue;
            }
            Query rapidViewQuery = outcome.getValue();
            if (this.queryService.isProjectClauseOnlyQuery(rapidViewQuery)) {
                projectsForBoard.put(rapidView, this.calculateProjectsInRapidView(user, rapidViewQuery));
                continue;
            }
            ServiceOutcome<Boolean> doesSprintMatch = this.doesSprintMatchQuery(user, defaultSprintField, sprintId, rapidViewQuery);
            if (!doesSprintMatch.isValid()) {
                return ServiceOutcomeImpl.error(doesSprintMatch);
            }
            if (!doesSprintMatch.getValue().booleanValue()) continue;
            boardsForThisSprint.add(rapidView);
        }
        if (!projectsForBoard.isEmpty()) {
            ServiceOutcome<Set<Long>> outcome = this.getProjectsForSprintId(user, defaultSprintField, sprintId);
            if (!outcome.isValid()) {
                return ServiceOutcomeImpl.error(outcome);
            }
            Set<Long> projectIdsForSprintId = outcome.getValue();
            for (Map.Entry boardProjects : projectsForBoard.entrySet()) {
                if (!CollectionUtils.containsAny(projectIdsForSprintId, (Collection)((Collection)boardProjects.getValue()))) continue;
                boardsForThisSprint.add((RapidView)boardProjects.getKey());
            }
        }
        return ServiceOutcomeImpl.ok(boardsForThisSprint);
    }

    @Override
    public ServiceOutcome<BoardLocation> getBoardLocationForIssue(ApplicationUser user, Issue issue, RapidView rapidView) {
        BoardLocationStrategy strategy = rapidView.isSprintSupportEnabled() ? new ScrumBoardLocationStrategy() : new KanbanBoardLocationStrategy();
        ServiceOutcome<BoardLocation> result = strategy.result(user, issue, rapidView);
        if (!result.isValid() || result.getValue() != null) {
            return result;
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.board.dispatch.error.no.location.for.issue", rapidView.getName());
    }

    @Override
    public ServiceOutcome<BoardLocation> getBoardLocationForSprint(ApplicationUser user, Sprint sprint) {
        switch (sprint.getState()) {
            case FUTURE: {
                return ServiceOutcomeImpl.ok(BoardLocation.forPlan());
            }
            case ACTIVE: {
                return ServiceOutcomeImpl.ok(BoardLocation.forWork());
            }
            case CLOSED: {
                return ServiceOutcomeImpl.ok(BoardLocation.forSprintReport(sprint.getId()));
            }
        }
        throw new RuntimeException("Unknown sprint state: " + (Object)((Object)sprint.getState()));
    }

    private void logWarningUnableToRetrieveQuery(RapidView rapidView, ServiceOutcome<?> outcome) {
        this.log.warn("Could not get the query for rapid view '%s' (%d) -- skipping", rapidView.getName(), rapidView.getId());
        this.log.warn(outcome.getErrors().toString(), new Object[0]);
    }

    private ServiceOutcome<Set<Long>> getProjectsForSprintId(ApplicationUser user, CustomField defaultSprintField, Long sprintId) {
        ProjectIssueDataCallback callback;
        Query sprintQuery = JqlQueryBuilder.newClauseBuilder().customField(defaultSprintField.getIdAsLong()).eq(sprintId).buildQuery();
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, sprintQuery, callback = new ProjectIssueDataCallback());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(callback.getProjectIds());
    }

    private Set<Long> calculateProjectsInRapidView(ApplicationUser user, Query rapidViewQuery) {
        HashSet<Long> projectIds = new HashSet<Long>();
        List<Project> projectsInProjectBasedQuery = this.queryService.getProjectsInProjectClauseOnlyQuery(user, rapidViewQuery);
        for (Project project : projectsInProjectBasedQuery) {
            projectIds.add(project.getId());
        }
        return projectIds;
    }

    private ServiceOutcome<Boolean> doesSprintMatchQuery(ApplicationUser user, CustomField defaultSprintField, Long sprintId, Query rapidViewQuery) {
        Query sprintQuery = JqlQueryBuilder.newBuilder((Query)rapidViewQuery).where().defaultAnd().customField(defaultSprintField.getIdAsLong()).eq(sprintId).buildQuery();
        ServiceOutcome<Long> outcome = this.searchService.searchCountOverrideSecurity(user, sprintQuery);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(outcome.getValue() > 0L);
    }

    private ServiceOutcome<Set<Query>> findQueriesMatchingIssue(ApplicationUser user, Map<Issue, Collection<Query>> rapidViewQueries) {
        return this.searchService.findQueriesMatchingIssue(user, rapidViewQueries);
    }

    private Collection<Sprint> getSprintsForIssue(Issue issue) {
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        return (Collection)issue.getCustomFieldValue(defaultSprintField);
    }

    static class CompositeStrategy
    implements BoardLocationStrategy {
        private List<BoardLocationStrategy> strategies;

        static BoardLocationStrategy create(BoardLocationStrategy ... strategies) {
            return new CompositeStrategy(Arrays.asList(strategies));
        }

        private CompositeStrategy(List<BoardLocationStrategy> strategies) {
            this.strategies = strategies;
        }

        @Override
        public ServiceOutcome<BoardLocation> result(ApplicationUser user, Issue issue, RapidView rapidView) {
            for (BoardLocationStrategy strategy : this.strategies) {
                ServiceOutcome<BoardLocation> result = strategy.result(user, issue, rapidView);
                if (result.isValid() && result.getValue() == null) continue;
                return result;
            }
            return ServiceOutcomeImpl.ok();
        }
    }

    class ScrumBoardLocationStrategy
    implements BoardLocationStrategy {
        private final BoardLocationStrategy strategy;

        ScrumBoardLocationStrategy() {
            this.strategy = CompositeStrategy.create(new SprintFieldBoardLocationStrategy(), new QueryingBoardLocationStrategy());
        }

        @Override
        public ServiceOutcome<BoardLocation> result(ApplicationUser user, Issue issue, RapidView rapidView) {
            return this.strategy.result(user, issue, rapidView);
        }
    }

    class QueryingBoardLocationStrategy
    implements BoardLocationStrategy {
        QueryingBoardLocationStrategy() {
        }

        @Override
        public ServiceOutcome<BoardLocation> result(ApplicationUser user, Issue issue, RapidView rapidView) {
            ServiceOutcome<Boolean> result;
            ServiceOutcome<Query> rapidViewQuery = RapidViewLocationServiceImpl.this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
            if (!rapidViewQuery.isValid()) {
                return ServiceOutcomeImpl.error(rapidViewQuery);
            }
            Issue issueToCheck = issue;
            if (issue.isSubTask()) {
                issueToCheck = issue.getParentObject();
            }
            if ((result = this.checkQuery(user, rapidView, rapidViewQuery.getValue(), issueToCheck, RapidViewClauseService.ClauseType.PLAN_MODE, RapidViewClauseService.ClauseType.VISIBLE_EPICS)).isValid() && result.getValue().booleanValue()) {
                return ServiceOutcomeImpl.ok(BoardLocation.forPlan());
            }
            if (!result.isValid()) {
                return ServiceOutcomeImpl.error(result);
            }
            result = this.checkQuery(user, rapidView, rapidViewQuery.getValue(), issue, RapidViewClauseService.ClauseType.SPRINT_REPORT_MODE);
            if (result.isValid() && result.getValue().booleanValue()) {
                return this.buildSprintReportResult(issue);
            }
            if (!result.isValid()) {
                return ServiceOutcomeImpl.error(result);
            }
            return ServiceOutcomeImpl.ok();
        }

        private ServiceOutcome<Boolean> checkQuery(ApplicationUser user, RapidView rapidView, Query rapidViewQuery, Issue issue, RapidViewClauseService.ClauseType ... clauseTypes) {
            JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery);
            jqlQueryBuilder.where().and().sub().defaultOr();
            for (RapidViewClauseService.ClauseType clauseType : clauseTypes) {
                ServiceOutcome<ClauseToAdd> clauseToAdd = RapidViewLocationServiceImpl.this.rapidViewClauseService.getClauseForBuilder(user, rapidView, clauseType);
                if (!clauseToAdd.isValid()) {
                    return ServiceOutcomeImpl.error(clauseToAdd);
                }
                clauseToAdd.getValue().append(jqlQueryBuilder);
            }
            jqlQueryBuilder.where().endsub();
            Query query = jqlQueryBuilder.buildQuery();
            ServiceOutcome doesIssueMatch = RapidViewLocationServiceImpl.this.findQueriesMatchingIssue(user, (Map)ImmutableMap.of((Object)issue, (Object)ImmutableSet.of((Object)query)));
            if (!doesIssueMatch.isValid()) {
                return ServiceOutcomeImpl.error(doesIssueMatch);
            }
            return ServiceOutcomeImpl.ok(!((Set)doesIssueMatch.getValue()).isEmpty());
        }

        private ServiceOutcome<BoardLocation> buildSprintReportResult(Issue issue) {
            Collection sprints = RapidViewLocationServiceImpl.this.getSprintsForIssue(issue);
            Sprint max = Collections.max(sprints, SprintUtils.SPRINT_BYDATE_COMPARATOR);
            return ServiceOutcomeImpl.ok(BoardLocation.forSprintReport(max.getId()));
        }
    }

    class SprintFieldBoardLocationStrategy
    implements BoardLocationStrategy {
        SprintFieldBoardLocationStrategy() {
        }

        @Override
        public ServiceOutcome<BoardLocation> result(ApplicationUser user, Issue issue, RapidView rapidView) {
            Collection sprints = RapidViewLocationServiceImpl.this.getSprintsForIssue(issue);
            if (sprints == null || sprints.isEmpty()) {
                return ServiceOutcomeImpl.ok();
            }
            for (Sprint sprint : sprints) {
                if (sprint.getState() != Sprint.State.ACTIVE) continue;
                return ServiceOutcomeImpl.ok(BoardLocation.forWork());
            }
            return ServiceOutcomeImpl.ok();
        }
    }

    class KanbanBoardLocationStrategy
    implements BoardLocationStrategy {
        KanbanBoardLocationStrategy() {
        }

        @Override
        public ServiceOutcome<BoardLocation> result(ApplicationUser user, Issue issue, RapidView rapidView) {
            Column column = RapidViewLocationServiceImpl.this.columnService.getColumnsByStatus(rapidView).get(issue.getStatus());
            if (KanbanBacklogColumn.isKanbanBacklogColumn(column)) {
                return ServiceOutcomeImpl.ok(BoardLocation.forPlan());
            }
            return ServiceOutcomeImpl.ok(BoardLocation.forWork());
        }
    }

    static interface BoardLocationStrategy {
        @Nonnull
        public ServiceOutcome<BoardLocation> result(ApplicationUser var1, Issue var2, RapidView var3);
    }
}

