/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidViewHistoryServiceImpl
implements RapidViewHistoryService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private UserHistoryItem.Type rapidViewHistoryType = new UserHistoryItem.Type("RapidView");
    @Autowired
    UserHistoryManager userHistoryManager;
    @Autowired
    RapidViewService rapidViewService;
    @Autowired
    private ProjectRapidViewService projectRapidViewService;

    @Override
    public void storeRapidView(ApplicationUser user, RapidView rapidView) {
        if (rapidView != null && rapidView.getId() != null) {
            this.userHistoryManager.addItemToHistory(this.rapidViewHistoryType, user, rapidView.getId().toString(), rapidView.getName());
        }
    }

    @Override
    public List<RapidView> getAllRecentViews(@Nullable ApplicationUser user) {
        return this.getRecentViews(user, -1, true);
    }

    @Override
    public List<RapidView> getRecentViews(ApplicationUser user, int count) {
        return this.getRecentViews(user, count, false);
    }

    @Override
    public Option<RapidView> getMostRecentRapidViewFromList(ApplicationUser user, Collection<RapidView> candidateRapidViews) {
        UserHistoryIterator iterator = new UserHistoryIterator(user);
        while (iterator.hasNext()) {
            Option<RapidView> mostRecentRapidView = this.getFirstRapidViewById(candidateRapidViews, iterator.next());
            if (!mostRecentRapidView.isDefined()) continue;
            return mostRecentRapidView;
        }
        return Option.none();
    }

    @Override
    public RapidView getMostRecent(ApplicationUser user) {
        List<RapidView> recentViews = this.getRecentViews(user, 1);
        if (recentViews.size() > 0) {
            return recentViews.get(0);
        }
        return null;
    }

    @Override
    public Option<RapidView> findMostRecentInProject(ApplicationUser user, Project project) {
        Optional<RapidView> rapidView = this.userHistoryManager.getHistory(this.rapidViewHistoryType, user).stream().flatMap(this::tryFetchRapidId).flatMap(id -> this.findRapidView(user, (Long)id)).filter(view -> this.isRapidViewInProject((RapidView)view, project, user)).findFirst();
        return this.toOption(rapidView);
    }

    private Option<RapidView> toOption(Optional<RapidView> rapidView) {
        return rapidView.map(Option::some).orElseGet(Option::none);
    }

    private Stream<RapidView> findRapidView(ApplicationUser user, Long id) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, id);
        if (rapidView.isValid()) {
            return Stream.of(rapidView.getValue());
        }
        return Stream.empty();
    }

    private Stream<Long> tryFetchRapidId(UserHistoryItem item) {
        try {
            return Stream.of(Long.valueOf(Long.parseLong(item.getEntityId())));
        }
        catch (NumberFormatException e) {
            this.log.debug("Couldn't parse entity id from {}", item);
            return Stream.empty();
        }
    }

    private boolean isRapidViewInProject(RapidView rapidView, Project project, ApplicationUser user) {
        return this.projectRapidViewService.findProjectsByRapidView(user, rapidView).fold(errors -> false, projects -> projects.contains(project));
    }

    private List<RapidView> getRecentViews(ApplicationUser user, int count, boolean getAll) {
        ArrayList<RapidView> results = new ArrayList<RapidView>();
        UserHistoryIterator iterator = new UserHistoryIterator(user);
        while (iterator.hasNext()) {
            ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, iterator.next());
            if (!rapidView.isValid()) continue;
            results.add(rapidView.getValue());
            if (getAll || results.size() < count) continue;
            break;
        }
        return results;
    }

    private Option<RapidView> getFirstRapidViewById(Collection<RapidView> rapidViews, Long rapidViewId) {
        return Iterables.findFirst(rapidViews, rapidView -> rapidView.getId().equals(rapidViewId));
    }

    private class UserHistoryIterator
    implements Iterator<Long> {
        private List<UserHistoryItem> userHistoryItems;
        private Iterator<UserHistoryItem> iterator;
        private Long rapidViewId;

        private UserHistoryIterator(ApplicationUser user) {
            this.userHistoryItems = RapidViewHistoryServiceImpl.this.userHistoryManager.getHistory(RapidViewHistoryServiceImpl.this.rapidViewHistoryType, user);
            this.iterator = this.userHistoryItems.iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.iterator.hasNext()) {
                String rapidViewIdAsString = this.iterator.next().getEntityId();
                this.rapidViewId = NumberUtils.toLong(rapidViewIdAsString);
                if (this.rapidViewId == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Long next() {
            return this.rapidViewId;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

