/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.MappedStatusIds;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewColumnServiceImpl
implements RapidViewColumnService {
    @Autowired
    private ColumnService columnService;

    @Override
    @Nonnull
    public ServiceOutcome<List<String>> getDoneStatusIds(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<MappedStatusIds> mappedStatusIds = this.getMappedStatusIds(user, rapidView);
        if (!mappedStatusIds.isValid()) {
            return ServiceOutcomeImpl.error(mappedStatusIds);
        }
        return ServiceOutcomeImpl.ok(mappedStatusIds.getValue().getDoneStatusIds());
    }

    @Override
    public ServiceOutcome<List<String>> getNotDoneStatusIds(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<MappedStatusIds> mappedStatusIds = this.getMappedStatusIds(user, rapidView);
        if (!mappedStatusIds.isValid()) {
            return ServiceOutcomeImpl.error(mappedStatusIds);
        }
        return ServiceOutcomeImpl.ok(mappedStatusIds.getValue().getNotDoneStatusIds());
    }

    @Override
    public ServiceOutcome<MappedStatusIds> getMappedStatusIds(ApplicationUser user, RapidView rapidView) {
        List<Column> columns = this.columnService.getVisibleColumns(rapidView);
        ArrayList<String> doneStatusIds = new ArrayList<String>();
        ArrayList<String> notDoneStatusIds = new ArrayList<String>();
        for (int i = columns.size() - 1; i >= 0; --i) {
            Column column = columns.get(i);
            if (doneStatusIds.isEmpty()) {
                doneStatusIds.addAll(column.getStatusIds());
                continue;
            }
            notDoneStatusIds.addAll(column.getStatusIds());
        }
        if (doneStatusIds.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.board.error.nostatusmapped", new Object[0]);
        }
        MappedStatusIds mappedStatusIds = new MappedStatusIds(doneStatusIds, notDoneStatusIds);
        return ServiceOutcomeImpl.ok(mappedStatusIds);
    }
}

