/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.RapidViewClauseService;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.service.subquery.SubqueryService;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderByImpl;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewClauseServiceImpl
implements RapidViewClauseService {
    @Autowired
    private SubqueryService subqueryService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private RapidViewColumnService rapidViewColumnService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private FeatureManager featureManager;

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getClauseForBuilder(ApplicationUser user, RapidView rapidView, RapidViewClauseService.ClauseType clauseType) {
        switch (clauseType) {
            case DEFINITION_OF_NOT_DONE: {
                return this.getDefinitionOfNotDoneClause(user, rapidView);
            }
            case DEFINITION_OF_DONE: {
                return this.getDefinitionOfDoneClause(user, rapidView);
            }
            case PLAN_MODE: {
                return this.getPlanModeClause(user, rapidView);
            }
            case PLAN_MODE_WITH_SUBTASKS: {
                return this.getPlanModeWithSubtasksClause(user, rapidView);
            }
            case PLAN_MODE_ACTIVE_SPRINTS: {
                return this.getPlanModeActiveSprintsClause(rapidView);
            }
            case PLAN_MODE_ISSUES: {
                return this.getPlanModeIssuesClause(user, rapidView);
            }
            case WORK_MODE: {
                return this.getWorkModeClause(user, rapidView);
            }
            case SPRINT_REPORT_MODE: {
                return this.getSprintReportModeClause(user, rapidView);
            }
            case VISIBLE_EPICS: {
                return this.getVisibleEpicsClause(user, rapidView);
            }
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Unknown ClauseType specified", new Object[0]);
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getPlanModeIssuesClause(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        ServiceOutcome<ClauseToAdd> definitionOfNotDone = this.getDefinitionOfNotDoneClause(user, rapidView);
        if (!definitionOfNotDone.isValid()) {
            return definitionOfNotDone;
        }
        JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        where.sub().addClause(this.sprintQueryService.getInOpenSprintClause()).or().addClause(definitionOfNotDone.getValue().getClause()).endsub();
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        where.issueType().notEq(epicIssues.getId());
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getPlanModeClause(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        where.sub().addClause(this.sprintQueryService.getNotInSprint()).or().addClause(this.sprintQueryService.getNotInOpenSprintClause()).endsub().and().issueTypeIsStandard();
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        where.issueType().notEq(epicIssues.getId());
        ServiceOutcome<ClauseToAdd> outcome = this.getDefinitionOfNotDoneClause(user, rapidView);
        if (!outcome.isValid()) {
            return outcome;
        }
        where = outcome.getValue().append(where);
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getKanbanPlanModeClause(ApplicationUser user, RapidView rapidView) {
        if (!this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN) || !this.columnService.isKanPlanEnabledForBoard(rapidView)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.boards.kanplan.error.feature.not.enabled", new Object[0]);
        }
        JqlClauseBuilder kanbanPlanModeClauseBuilder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        String[] relevantStatusIds = this.getRelevantStatusIdsForKanbanPlanMode(rapidView);
        if (relevantStatusIds.length != 0) {
            kanbanPlanModeClauseBuilder.status(relevantStatusIds);
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(kanbanPlanModeClauseBuilder.buildClause()));
    }

    private String[] getRelevantStatusIdsForKanbanPlanMode(RapidView rapidView) {
        List<Column> mappedColumns = this.columnService.getValidColumns(rapidView);
        Column backlogColumn = mappedColumns.get(0);
        Preconditions.checkState((boolean)KanbanBacklogColumn.isKanbanBacklogColumn(backlogColumn));
        ArrayList<String> relevantStatusIds = new ArrayList<String>();
        relevantStatusIds.addAll(backlogColumn.getStatusIds());
        if (mappedColumns.size() > 1) {
            Column selectedForDevColumn = mappedColumns.get(1);
            relevantStatusIds.addAll(selectedForDevColumn.getStatusIds());
        }
        return relevantStatusIds.toArray(new String[relevantStatusIds.size()]);
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getPlanModeWithSubtasksClause(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        where.sub().addClause(this.sprintQueryService.getNotInSprint()).or().addClause(this.sprintQueryService.getNotInOpenSprintClause()).endsub();
        ServiceOutcome<ClauseToAdd> outcome = this.getDefinitionOfNotDoneClause(user, rapidView);
        if (!outcome.isValid()) {
            return outcome;
        }
        where.sub().sub().issueTypeIsStandard();
        outcome.getValue().append(where);
        where.endsub().or().issueTypeIsSubtask().endsub();
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        where.issueType().notEq(epicIssues.getId());
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getPlanModeActiveSprintsClause(RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder().defaultAnd().issueTypeIsStandard().addClause(this.sprintQueryService.getInOpenSprintClause());
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getWorkModeClause(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            ServiceOutcome<ClauseToAdd> clauseToAddOutcome = this.getSubQueryClause(user, rapidView);
            if (clauseToAddOutcome.isInvalid()) {
                return clauseToAddOutcome;
            }
            ClauseToAdd clauseToAdd = clauseToAddOutcome.get();
            if (this.columnService.isKanPlanEnabledForBoard(rapidView) && this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN_EPICS_AND_VERSIONS) && rapidView.getShowEpicsAsPanel().isEnabled()) {
                IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
                JqlQueryBuilder excludeEpicTypeQuery = JqlQueryBuilder.newBuilder().where().issueType().notEq(epicIssueType.getId()).endWhere();
                Clause clause = clauseToAdd.appendWithDefaultAnd(excludeEpicTypeQuery).buildQuery().getWhereClause();
                return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(clause));
            }
            return ServiceOutcomeImpl.ok(clauseToAdd);
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(this.sprintQueryService.getInOpenSprintClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getSprintReportModeClause(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(this.sprintQueryService.getInSprintClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getDefinitionOfDoneClause(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<List<String>> statusIdList = this.rapidViewColumnService.getDoneStatusIds(user, rapidView);
        if (!statusIdList.isValid()) {
            return ServiceOutcomeImpl.error(statusIdList);
        }
        JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        String[] statusIds = statusIdList.getValue().toArray(new String[statusIdList.getValue().size()]);
        where.status().in(statusIds);
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getDefinitionOfNotDoneClause(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<ClauseToAdd> addedDefinitionOfDoneOutcome = this.getDefinitionOfDoneClause(user, rapidView);
        if (!addedDefinitionOfDoneOutcome.isValid()) {
            return ServiceOutcomeImpl.error(addedDefinitionOfDoneOutcome);
        }
        if (addedDefinitionOfDoneOutcome.getValue().hasClause()) {
            JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder();
            where.not().sub();
            addedDefinitionOfDoneOutcome.getValue().append(where);
            where.endsub();
            return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<ClauseToAdd> getSubQueryClause(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Subquery> subquery = this.subqueryService.getSubquery(user, rapidView);
        if (!subquery.isValid()) {
            return ServiceOutcomeImpl.error(subquery);
        }
        String subQueryString = subquery.get().getQuery();
        if (!StringUtils.isBlank((CharSequence)subQueryString)) {
            ServiceOutcome<Query> parsedQuery = this.jqlHelper.createQuery(user, subQueryString);
            if (!parsedQuery.isValid()) {
                return ServiceOutcomeImpl.error(parsedQuery);
            }
            if (!parsedQuery.get().getOrderByClause().equals(OrderByImpl.NO_ORDER)) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.board.error.subquery.orderby", new Object[0]);
            }
            return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(parsedQuery.getValue().getWhereClause()));
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
    }

    @Override
    @Nonnull
    public ServiceOutcome<ClauseToAdd> getVisibleEpicsClause(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok(ClauseToAdd.noClauseToAdd());
        }
        JqlClauseBuilder where = JqlQueryBuilder.newClauseBuilder();
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        where.issueType().eq(epicIssues.getId());
        CustomField defaultEpicStatusField = this.epicCustomFieldService.getDefaultEpicStatusField();
        io.atlassian.fugue.Option<Option> doneEpicStatusOption = this.epicCustomFieldService.getDoneEpicStatusOption();
        if (doneEpicStatusOption.isDefined()) {
            where.defaultAnd().sub().customField(defaultEpicStatusField.getIdAsLong()).notEq(((Option)doneEpicStatusOption.get()).getValue()).or().customField(defaultEpicStatusField.getIdAsLong()).isEmpty().endsub();
        }
        return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(where.buildClause()));
    }
}

