/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.RapidViewCacheManager;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAOMapper;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewCacheManagerImpl
implements RapidViewCacheManager {
    private static final LoggerWrapper log = LoggerWrapper.with(RapidViewCacheManagerImpl.class);
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private RapidViewAOMapper rapidViewAOMapper;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, Option<RapidView>> rapidViewCache;

    @PostConstruct
    private void init() {
        this.rapidViewCache = this.cacheFactoryManager.create().getCache(RapidViewCacheManagerImpl.class.getName() + ".rapidViewCache", new RapidViewCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public Option<RapidView> get(Long rapidViewId) {
        return this.rapidViewCache.get(rapidViewId);
    }

    @Override
    public void remove(Long rapidViewId) {
        this.rapidViewCache.remove(rapidViewId);
    }

    @Override
    public void removeAll() {
        this.rapidViewCache.removeAll();
    }

    private class RapidViewCacheLoader
    implements CacheLoader<Long, Option<RapidView>> {
        private RapidViewCacheLoader() {
        }

        @Override
        public Option<RapidView> load(@Nonnull Long rapidViewId) {
            ServiceOutcome rapidViewAO = RapidViewCacheManagerImpl.this.rapidViewDao.load(rapidViewId);
            if (!rapidViewAO.isValid()) {
                return Option.none();
            }
            RapidView rapidView = RapidViewCacheManagerImpl.this.rapidViewAOMapper.toModel((RapidViewAO)rapidViewAO.getValue());
            log.debug("Populating RapidView cache [id=%d]", rapidView.getId());
            return Option.some((Object)rapidView);
        }
    }
}

